import { ContainerDefinition } from "../../../aws-ecs";
/**
 * (experimental) A list of container overrides that specify the name of a container and the overrides it should receive.
 *
 * @experimental
 */
export interface ContainerOverride {
    /**
     * (experimental) Name of the container inside the task definition.
     *
     * @experimental
     */
    readonly containerDefinition: ContainerDefinition;
    /**
     * (experimental) Command to run inside the container.
     *
     * @default - Default command from the Docker image or the task definition
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The environment variables to send to the container.
     *
     * You can add new environment variables, which are added to the container at launch,
     * or you can override the existing environment variables from the Docker image or the task definition.
     *
     * @default - The existing environment variables from the Docker image or the task definition
     * @experimental
     */
    readonly environment?: TaskEnvironmentVariable[];
    /**
     * (experimental) The number of cpu units reserved for the container.
     *
     * @default - The default value from the task definition.
     * @experimental
     */
    readonly cpu?: number;
    /**
     * (experimental) The hard limit (in MiB) of memory to present to the container.
     *
     * @default - The default value from the task definition.
     * @experimental
     */
    readonly memoryLimit?: number;
    /**
     * (experimental) The soft limit (in MiB) of memory to reserve for the container.
     *
     * @default - The default value from the task definition.
     * @experimental
     */
    readonly memoryReservation?: number;
}
/**
 * (experimental) An environment variable to be set in the container run as a task.
 *
 * @experimental
 */
export interface TaskEnvironmentVariable {
    /**
     * (experimental) Name for the environment variable.
     *
     * Use `JsonPath` class's static methods to specify name from a JSON path.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Value of the environment variable.
     *
     * Use `JsonPath` class's static methods to specify value from a JSON path.
     *
     * @experimental
     */
    readonly value: string;
}
