import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import { CommonEcsRunTaskProps, EcsRunTaskBase } from './run-ecs-task-base';
/**
 * (deprecated) Properties to run an ECS task on EC2 in StepFunctionsan ECS.
 *
 * @deprecated use `EcsRunTask` and `EcsRunTaskProps`
 */
export interface RunEcsEc2TaskProps extends CommonEcsRunTaskProps {
    /**
     * (deprecated) In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @deprecated
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * (deprecated) Existing security group to use for the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     * @deprecated
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (deprecated) Placement constraints.
     *
     * @default No constraints
     * @deprecated
     */
    readonly placementConstraints?: ecs.PlacementConstraint[];
    /**
     * (deprecated) Placement strategies.
     *
     * @default No strategies
     * @deprecated
     */
    readonly placementStrategies?: ecs.PlacementStrategy[];
}
/**
 * (deprecated) Run an ECS/EC2 Task in a StepFunctions workflow.
 *
 * @deprecated - replaced by `EcsRunTask`
 */
export declare class RunEcsEc2Task extends EcsRunTaskBase {
    /**
     * @deprecated
     */
    constructor(props: RunEcsEc2TaskProps);
}
