import * as ddb from "../../../aws-dynamodb";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { DynamoAttributeValue, DynamoConsumedCapacity, DynamoItemCollectionMetrics, DynamoReturnValues } from './shared-types';
/**
 * (experimental) Properties for DynamoDeleteItem Task.
 *
 * @experimental
 */
export interface DynamoDeleteItemProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The name of the table containing the requested item.
     *
     * @experimental
     */
    readonly table: ddb.ITable;
    /**
     * (experimental) Primary key of the item to retrieve.
     *
     * For the primary key, you must provide all of the attributes.
     * For example, with a simple primary key, you only need to provide a value for the partition key.
     * For a composite primary key, you must provide values for both the partition key and the sort key.
     *
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key
     * @experimental
     */
    readonly key: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * (experimental) A condition that must be satisfied in order for a conditional DeleteItem to succeed.
     *
     * @default - No condition expression
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ConditionExpression
     * @experimental
     */
    readonly conditionExpression?: string;
    /**
     * (experimental) One or more substitution tokens for attribute names in an expression.
     *
     * @default - No expression attribute names
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeNames
     * @experimental
     */
    readonly expressionAttributeNames?: {
        [key: string]: string;
    };
    /**
     * (experimental) One or more values that can be substituted in an expression.
     *
     * @default - No expression attribute values
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeValues
     * @experimental
     */
    readonly expressionAttributeValues?: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * (experimental) Determines the level of detail about provisioned throughput consumption that is returned in the response.
     *
     * @default DynamoConsumedCapacity.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnConsumedCapacity
     * @experimental
     */
    readonly returnConsumedCapacity?: DynamoConsumedCapacity;
    /**
     * (experimental) Determines whether item collection metrics are returned.
     *
     * If set to SIZE, the response includes statistics about item collections, if any,
     * that were modified during the operation are returned in the response.
     * If set to NONE (the default), no statistics are returned.
     *
     * @default DynamoItemCollectionMetrics.NONE
     * @experimental
     */
    readonly returnItemCollectionMetrics?: DynamoItemCollectionMetrics;
    /**
     * (experimental) Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
     *
     * @default DynamoReturnValues.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnValues
     * @experimental
     */
    readonly returnValues?: DynamoReturnValues;
}
/**
 * (experimental) A StepFunctions task to call DynamoDeleteItem.
 *
 * @experimental
 */
export declare class DynamoDeleteItem extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DynamoDeleteItemProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
