import * as codebuild from "../../../aws-codebuild";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for CodeBuildStartBuild.
 *
 * @experimental
 */
export interface CodeBuildStartBuildProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) CodeBuild project to start.
     *
     * @experimental
     */
    readonly project: codebuild.IProject;
    /**
     * (experimental) A set of environment variables to be used for this build only.
     *
     * @default - the latest environment variables already defined in the build project.
     * @experimental
     */
    readonly environmentVariablesOverride?: {
        [name: string]: codebuild.BuildEnvironmentVariable;
    };
}
/**
 * (experimental) Start a CodeBuild Build as a task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-codebuild.html
 * @experimental
 */
export declare class CodeBuildStartBuild extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CodeBuildStartBuildProps);
    private configurePolicyStatements;
    /**
     * Provides the CodeBuild StartBuild service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
    private serializeEnvVariables;
}
