"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayRestApiEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const base_1 = require("./base");
/**
 * (experimental) Call REST API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @experimental
 */
class CallApiGatewayRestApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = props.api.arnForExecuteApi(props.method, props.apiPath, props.stageName);
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = cdk.Stack.of(this.props.api);
        return `${this.props.api.restApiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
}
exports.CallApiGatewayRestApiEndpoint = CallApiGatewayRestApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayRestApiEndpoint[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.CallApiGatewayRestApiEndpoint", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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