import * as apigateway from "../../../aws-apigateway";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { CallApiGatewayEndpointBase } from './base';
import { CallApiGatewayEndpointBaseProps } from './base-types';
/**
 * (experimental) Properties for calling an REST API Endpoint.
 *
 * @experimental
 */
export interface CallApiGatewayRestApiEndpointProps extends CallApiGatewayEndpointBaseProps {
    /**
     * (experimental) API to call.
     *
     * @experimental
     */
    readonly api: apigateway.IRestApi;
    /**
     * (experimental) Name of the stage where the API is deployed to in API Gateway.
     *
     * @experimental
     */
    readonly stageName: string;
}
/**
 * (experimental) Call REST API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @experimental
 */
export declare class CallApiGatewayRestApiEndpoint extends CallApiGatewayEndpointBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig | undefined;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[] | undefined;
    /**
     * @experimental
     */
    protected readonly apiEndpoint: string;
    /**
     * @experimental
     */
    protected readonly arnForExecuteApi: string;
    /**
     * @experimental
     */
    protected readonly stageName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CallApiGatewayRestApiEndpointProps);
    private getApiEndpoint;
}
