"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_1 = require("./base");
/**
 * (experimental) Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @experimental
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = this.props.apiStack;
        return `${this.props.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { apiId, stageName, method, apiPath } = this.props;
        return this.props.apiStack.formatArn({
            service: 'execute-api',
            resource: apiId,
            sep: '/',
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.CallApiGatewayHttpApiEndpoint", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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