import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { CallApiGatewayEndpointBase } from './base';
import { CallApiGatewayEndpointBaseProps } from './base-types';
/**
 * (experimental) Properties for calling an HTTP API Endpoint.
 *
 * @experimental
 */
export interface CallApiGatewayHttpApiEndpointProps extends CallApiGatewayEndpointBaseProps {
    /**
     * (experimental) The Id of the API to call.
     *
     * @experimental
     */
    readonly apiId: string;
    /**
     * (experimental) The Stack in which the API is defined.
     *
     * @experimental
     */
    readonly apiStack: cdk.Stack;
    /**
     * (experimental) Name of the stage where the API is deployed to in API Gateway.
     *
     * @default '$default'
     * @experimental
     */
    readonly stageName?: string;
}
/**
 * (experimental) Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @experimental
 */
export declare class CallApiGatewayHttpApiEndpoint extends CallApiGatewayEndpointBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig | undefined;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[] | undefined;
    /**
     * @experimental
     */
    protected readonly apiEndpoint: string;
    /**
     * @experimental
     */
    protected readonly arnForExecuteApi: string;
    /**
     * @experimental
     */
    protected readonly stageName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CallApiGatewayHttpApiEndpointProps);
    private getApiEndpoint;
    private getArnForExecuteApi;
}
