"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayEndpointBase = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const task_utils_1 = require("../private/task-utils");
const base_types_1 = require("./base-types");
/**
 * Base CallApiGatewayEndpoint Task
 * @internal
 */
class CallApiGatewayEndpointBase extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        this.baseProps = props;
        this.integrationPattern = (_a = props.integrationPattern) !== null && _a !== void 0 ? _a : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, CallApiGatewayEndpointBase.SUPPORTED_INTEGRATION_PATTERNS);
        if (this.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(this.baseProps.headers)) {
                throw new Error('Task Token is required in `headers` for WAIT_FOR_TASK_TOKEN pattern. Use JsonPath.taskToken to set the token.');
            }
        }
    }
    /**
     * @internal
     */
    _renderTask() {
        var _a, _b, _c;
        return {
            Resource: task_utils_1.integrationResourceArn('apigateway', 'invoke', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                ApiEndpoint: this.apiEndpoint,
                Method: this.baseProps.method,
                Headers: (_a = this.baseProps.headers) === null || _a === void 0 ? void 0 : _a.value,
                Stage: this.stageName,
                Path: this.baseProps.apiPath,
                QueryParameters: (_b = this.baseProps.queryParameters) === null || _b === void 0 ? void 0 : _b.value,
                RequestBody: (_c = this.baseProps.requestBody) === null || _c === void 0 ? void 0 : _c.value,
                AuthType: this.baseProps.authType ? this.baseProps.authType : 'NO_AUTH',
            }),
        };
    }
    /**
     * @experimental
     */
    createPolicyStatements() {
        if (this.baseProps.authType === base_types_1.AuthType.NO_AUTH) {
            return [];
        }
        return [
            new iam.PolicyStatement({
                resources: [this.arnForExecuteApi],
                actions: ['execute-api:Invoke'],
            }),
        ];
    }
}
exports.CallApiGatewayEndpointBase = CallApiGatewayEndpointBase;
CallApiGatewayEndpointBase.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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