import * as sfn from "../../../aws-stepfunctions";
/**
 * (experimental) Http Methods that API Gateway supports.
 *
 * @experimental
 */
export declare enum HttpMethod {
    /**
     * (experimental) Retreive data from a server at the specified resource.
     *
     * @experimental
     */
    GET = "GET",
    /**
     * (experimental) Send data to the API endpoint to create or udpate a resource.
     *
     * @experimental
     */
    POST = "POST",
    /**
     * (experimental) Send data to the API endpoint to update or create a resource.
     *
     * @experimental
     */
    PUT = "PUT",
    /**
     * (experimental) Delete the resource at the specified endpoint.
     *
     * @experimental
     */
    DELETE = "DELETE",
    /**
     * (experimental) Apply partial modifications to the resource.
     *
     * @experimental
     */
    PATCH = "PATCH",
    /**
     * (experimental) Retreive data from a server at the specified resource without the response body.
     *
     * @experimental
     */
    HEAD = "HEAD",
    /**
     * (experimental) Return data describing what other methods and operations the server supports.
     *
     * @experimental
     */
    OPTIONS = "OPTIONS"
}
/**
 * (experimental) The authentication method used to call the endpoint.
 *
 * @experimental
 */
export declare enum AuthType {
    /**
     * (experimental) Call the API direclty with no authorization method.
     *
     * @experimental
     */
    NO_AUTH = "NO_AUTH",
    /**
     * (experimental) Use the IAM role associated with the current state machine for authorization.
     *
     * @experimental
     */
    IAM_ROLE = "IAM_ROLE",
    /**
     * (experimental) Use the resource policy of the API for authorization.
     *
     * @experimental
     */
    RESOURCE_POLICY = "RESOURCE_POLICY"
}
/**
 * (experimental) Base CallApiGatewayEdnpoint Task Props.
 *
 * @experimental
 */
export interface CallApiGatewayEndpointBaseProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Http method for the API.
     *
     * @experimental
     */
    readonly method: HttpMethod;
    /**
     * (experimental) HTTP request information that does not relate to contents of the request.
     *
     * @default - No headers
     * @experimental
     */
    readonly headers?: sfn.TaskInput;
    /**
     * (experimental) Path parameters appended after API endpoint.
     *
     * @default - No path
     * @experimental
     */
    readonly apiPath?: string;
    /**
     * (experimental) Query strings attatched to end of request.
     *
     * @default - No query parameters
     * @experimental
     */
    readonly queryParameters?: sfn.TaskInput;
    /**
     * (experimental) HTTP Request body.
     *
     * @default - No request body
     * @experimental
     */
    readonly requestBody?: sfn.TaskInput;
    /**
     * (experimental) Authentication methods.
     *
     * @default AuthType.NO_AUTH
     * @experimental
     */
    readonly authType?: AuthType;
}
