"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SQSMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class SQSMetrics {
    static numberOfMessagesSentAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'NumberOfMessagesSent',
            dimensions,
            statistic: 'Average',
        };
    }
    static approximateNumberOfMessagesDelayedAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'ApproximateNumberOfMessagesDelayed',
            dimensions,
            statistic: 'Average',
        };
    }
    static numberOfMessagesReceivedAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'NumberOfMessagesReceived',
            dimensions,
            statistic: 'Average',
        };
    }
    static numberOfMessagesDeletedAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'NumberOfMessagesDeleted',
            dimensions,
            statistic: 'Average',
        };
    }
    static approximateNumberOfMessagesNotVisibleAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'ApproximateNumberOfMessagesNotVisible',
            dimensions,
            statistic: 'Average',
        };
    }
    static approximateNumberOfMessagesVisibleAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'ApproximateNumberOfMessagesVisible',
            dimensions,
            statistic: 'Average',
        };
    }
    static approximateAgeOfOldestMessageAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'ApproximateAgeOfOldestMessage',
            dimensions,
            statistic: 'Average',
        };
    }
    static numberOfEmptyReceivesAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'NumberOfEmptyReceives',
            dimensions,
            statistic: 'Average',
        };
    }
    static sentMessageSizeAverage(dimensions) {
        return {
            namespace: 'AWS/SQS',
            metricName: 'SentMessageSize',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.SQSMetrics = SQSMetrics;
//# sourceMappingURL=data:application/json;base64,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