import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { IResource, Resource } from "../../core";
/**
 * (experimental) Represents an SQS queue.
 *
 * @experimental
 */
export interface IQueue extends IResource {
    /**
     * (experimental) The ARN of this queue.
     *
     * @experimental
     * @attribute true
     */
    readonly queueArn: string;
    /**
     * (experimental) The URL of this queue.
     *
     * @experimental
     * @attribute true
     */
    readonly queueUrl: string;
    /**
     * (experimental) The name of this queue.
     *
     * @experimental
     * @attribute true
     */
    readonly queueName: string;
    /**
     * (experimental) If this queue is server-side encrypted, this is the KMS encryption key.
     *
     * @experimental
     */
    readonly encryptionMasterKey?: kms.IKey;
    /**
     * (experimental) Whether this queue is an Amazon SQS FIFO queue.
     *
     * If false, this is a standard queue.
     *
     * @experimental
     */
    readonly fifo: boolean;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this queue.
     *
     * If this queue was created in this stack (`new Queue`), a queue policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the queue is imported (`Queue.import`), then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant permissions to consume messages from a queue.
     *
     * This will grant the following permissions:
     *
     *    - sqs:ChangeMessageVisibility
     *    - sqs:DeleteMessage
     *    - sqs:ReceiveMessage
     *    - sqs:GetQueueAttributes
     *    - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant consume rights to.
     * @experimental
     */
    grantConsumeMessages(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant access to send messages to a queue to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - sqs:SendMessage
     *   - sqs:GetQueueAttributes
     *   - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant send rights to.
     * @experimental
     */
    grantSendMessages(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant an IAM principal permissions to purge all messages from the queue.
     *
     * This will grant the following permissions:
     *
     *   - sqs:PurgeQueue
     *   - sqs:GetQueueAttributes
     *   - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant send rights to.
     * @experimental
     */
    grantPurge(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
     *
     * @param grantee Principal to grant right to.
     * @param queueActions The actions to grant.
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...queueActions: string[]): iam.Grant;
}
/**
 * (experimental) Reference to a new or existing Amazon SQS queue.
 *
 * @experimental
 */
export declare abstract class QueueBase extends Resource implements IQueue {
    /**
     * (experimental) The ARN of this queue.
     *
     * @experimental
     */
    abstract readonly queueArn: string;
    /**
     * (experimental) The URL of this queue.
     *
     * @experimental
     */
    abstract readonly queueUrl: string;
    /**
     * (experimental) The name of this queue.
     *
     * @experimental
     */
    abstract readonly queueName: string;
    /**
     * (experimental) If this queue is server-side encrypted, this is the KMS encryption key.
     *
     * @experimental
     */
    abstract readonly encryptionMasterKey?: kms.IKey;
    /**
     * (experimental) Whether this queue is an Amazon SQS FIFO queue.
     *
     * If false, this is a standard queue.
     *
     * @experimental
     */
    abstract readonly fifo: boolean;
    /**
     * (experimental) Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     *
     * @experimental
     */
    protected abstract readonly autoCreatePolicy: boolean;
    private policy?;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this queue.
     *
     * If this queue was created in this stack (`new Queue`), a queue policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the queue is imported (`Queue.import`), then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Grant permissions to consume messages from a queue.
     *
     * This will grant the following permissions:
     *
     *    - sqs:ChangeMessageVisibility
     *    - sqs:DeleteMessage
     *    - sqs:ReceiveMessage
     *    - sqs:GetQueueAttributes
     *    - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant consume rights to.
     * @experimental
     */
    grantConsumeMessages(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant access to send messages to a queue to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - sqs:SendMessage
     *   - sqs:GetQueueAttributes
     *   - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant send rights to.
     * @experimental
     */
    grantSendMessages(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant an IAM principal permissions to purge all messages from the queue.
     *
     * This will grant the following permissions:
     *
     *   - sqs:PurgeQueue
     *   - sqs:GetQueueAttributes
     *   - sqs:GetQueueUrl
     *
     * @param grantee Principal to grant send rights to.
     * @experimental
     */
    grantPurge(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
     *
     * @param grantee Principal to grant right to.
     * @param actions The actions to grant.
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * (experimental) Reference to a queue.
 *
 * @experimental
 */
export interface QueueAttributes {
    /**
     * (experimental) The ARN of the queue.
     *
     * @experimental
     */
    readonly queueArn: string;
    /**
     * (experimental) The URL of the queue.
     *
     * @default - 'https://sqs.<region-endpoint>/<account-ID>/<queue-name>'
     * @see https://docs.aws.amazon.com/sdk-for-net/v2/developer-guide/QueueURL.html
     * @experimental
     */
    readonly queueUrl?: string;
    /**
     * (experimental) The name of the queue.
     *
     * @default if queue name is not specified, the name will be derived from the queue ARN
     * @experimental
     */
    readonly queueName?: string;
    /**
     * (experimental) KMS encryption key, if this queue is server-side encrypted by a KMS key.
     *
     * @default - None
     * @experimental
     */
    readonly keyArn?: string;
}
