"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) A subscription filter for an attribute.
 *
 * @experimental
 */
class SubscriptionFilter {
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @experimental
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * (experimental) Returns a subscription filter for a string attribute.
     *
     * @experimental
     */
    static stringFilter(stringConditions) {
        var _b, _c;
        const conditions = new Array();
        if (stringConditions.whitelist && stringConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        if (stringConditions.blacklist && stringConditions.denylist) {
            throw new Error('`blacklist` is deprecated; please use `denylist` instead');
        }
        const allowlist = (_b = stringConditions.allowlist) !== null && _b !== void 0 ? _b : stringConditions.whitelist;
        const denylist = (_c = stringConditions.denylist) !== null && _c !== void 0 ? _c : stringConditions.blacklist;
        if (allowlist) {
            conditions.push(...allowlist);
        }
        if (denylist) {
            conditions.push({ 'anything-but': denylist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * (experimental) Returns a subscription filter for a numeric attribute.
     *
     * @experimental
     */
    static numericFilter(numericConditions) {
        var _b;
        const conditions = new Array();
        if (numericConditions.whitelist && numericConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        const allowlist = (_b = numericConditions.allowlist) !== null && _b !== void 0 ? _b : numericConditions.whitelist;
        if (allowlist) {
            conditions.push(...allowlist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * (experimental) Returns a subscription filter for attribute key matching.
     *
     * @experimental
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "monocdk.aws_sns.SubscriptionFilter", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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