"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sns_generated_1 = require("./sns.generated");
/**
 * (experimental) Applies a policy to SNS topics.
 *
 * @experimental
 */
class TopicPolicy extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        /**
         * (experimental) The IAM policy document for this policy.
         *
         * @experimental
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        this.document = (_b = props.policyDocument) !== null && _b !== void 0 ? _b : this.document;
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
_a = JSII_RTTI_SYMBOL_1;
TopicPolicy[_a] = { fqn: "monocdk.aws_sns.TopicPolicy", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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