"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlSubscription = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a URL as a subscription target.
 *
 * The message will be POSTed to the given URL.
 *
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-http-https-endpoint-as-subscriber.html
 * @experimental
 */
class UrlSubscription {
    /**
     * @experimental
     */
    constructor(url, props = {}) {
        this.url = url;
        this.props = props;
        this.unresolvedUrl = core_1.Token.isUnresolved(url);
        if (!this.unresolvedUrl && !url.startsWith('http://') && !url.startsWith('https://')) {
            throw new Error('URL must start with either http:// or https://');
        }
        if (this.unresolvedUrl && props.protocol === undefined) {
            throw new Error('Must provide protocol if url is unresolved');
        }
        if (this.unresolvedUrl) {
            this.protocol = props.protocol;
        }
        else {
            this.protocol = this.url.startsWith('https:') ? sns.SubscriptionProtocol.HTTPS : sns.SubscriptionProtocol.HTTP;
        }
    }
    /**
     * (experimental) Returns a configuration for a URL to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic) {
        return {
            subscriberId: this.url,
            endpoint: this.url,
            protocol: this.protocol,
            rawMessageDelivery: this.props.rawMessageDelivery,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.UrlSubscription = UrlSubscription;
_a = JSII_RTTI_SYMBOL_1;
UrlSubscription[_a] = { fqn: "monocdk.aws_sns_subscriptions.UrlSubscription", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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