import * as sns from "../../aws-sns";
import { IQueue } from "../../aws-sqs";
/**
 * (experimental) Options to subscribing to an SNS topic.
 *
 * @experimental
 */
export interface SubscriptionProps {
    /**
     * (experimental) The filter policy.
     *
     * @default - all messages are delivered
     * @experimental
     */
    readonly filterPolicy?: {
        [attribute: string]: sns.SubscriptionFilter;
    };
    /**
     * (experimental) Queue to be used as dead letter queue.
     *
     * If not passed no dead letter queue is enabled.
     *
     * @default - No dead letter queue enabled.
     * @experimental
     */
    readonly deadLetterQueue?: IQueue;
}
