import * as sns from "../../aws-sns";
import * as sqs from "../../aws-sqs";
import { SubscriptionProps } from './subscription';
/**
 * (experimental) Properties for an SQS subscription.
 *
 * @experimental
 */
export interface SqsSubscriptionProps extends SubscriptionProps {
    /**
     * (experimental) The message to the queue is the same as it was sent to the topic.
     *
     * If false, the message will be wrapped in an SNS envelope.
     *
     * @default false
     * @experimental
     */
    readonly rawMessageDelivery?: boolean;
}
/**
 * (experimental) Use an SQS queue as a subscription target.
 *
 * @experimental
 */
export declare class SqsSubscription implements sns.ITopicSubscription {
    private readonly queue;
    private readonly props;
    /**
     * @experimental
     */
    constructor(queue: sqs.IQueue, props?: SqsSubscriptionProps);
    /**
     * (experimental) Returns a configuration for an SQS queue to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(topic: sns.ITopic): sns.TopicSubscriptionConfig;
    private regionFromArn;
}
