"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailSubscription = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
/**
 * (experimental) Use an email address as a subscription target.
 *
 * Email subscriptions require confirmation.
 *
 * @experimental
 */
class EmailSubscription {
    /**
     * @experimental
     */
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    /**
     * (experimental) Returns a configuration for an email address to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
_a = JSII_RTTI_SYMBOL_1;
EmailSubscription[_a] = { fqn: "monocdk.aws_sns_subscriptions.EmailSubscription", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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