"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SigningProfile = exports.Platform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const signer_generated_1 = require("./signer.generated");
/**
 * (experimental) Platforms that are allowed with signing config.
 *
 * @see https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html
 * @experimental
 */
class Platform {
    constructor(platformId) {
        this.platformId = platformId;
    }
}
exports.Platform = Platform;
_a = JSII_RTTI_SYMBOL_1;
Platform[_a] = { fqn: "monocdk.aws_signer.Platform", version: "1.106.1" };
/**
 * (experimental) Specification of signature format and signing algorithms for AWS IoT Device.
 *
 * @experimental
 */
Platform.AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA = new Platform('AWSIoTDeviceManagement-SHA256-ECDSA');
/**
 * (experimental) Specification of signature format and signing algorithms for AWS Lambda.
 *
 * @experimental
 */
Platform.AWS_LAMBDA_SHA384_ECDSA = new Platform('AWSLambda-SHA384-ECDSA');
/**
 * (experimental) Specification of signature format and signing algorithms with SHA1 hash and RSA encryption for Amazon FreeRTOS.
 *
 * @experimental
 */
Platform.AMAZON_FREE_RTOS_TI_CC3220SF = new Platform('AmazonFreeRTOS-TI-CC3220SF');
/**
 * (experimental) Specification of signature format and signing algorithms with SHA256 hash and ECDSA encryption for Amazon FreeRTOS.
 *
 * @experimental
 */
Platform.AMAZON_FREE_RTOS_DEFAULT = new Platform('AmazonFreeRTOS-Default');
/**
 * (experimental) Defines a Signing Profile.
 *
 * @experimental
 * @resource AWS::Signer::SigningProfile
 */
class SigningProfile extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id, {
            physicalName: props.signingProfileName,
        });
        const resource = new signer_generated_1.CfnSigningProfile(this, 'Resource', {
            platformId: props.platform.platformId,
            signatureValidityPeriod: props.signatureValidity ? {
                type: 'DAYS',
                value: (_c = props.signatureValidity) === null || _c === void 0 ? void 0 : _c.toDays(),
            } : {
                type: 'MONTHS',
                value: 135,
            },
        });
        this.signingProfileArn = resource.attrArn;
        this.signingProfileName = resource.attrProfileName;
        this.signingProfileVersion = resource.attrProfileVersion;
        this.signingProfileVersionArn = resource.attrProfileVersionArn;
    }
    /**
     * (experimental) Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `SigningProfileAttributes` object.
     * @experimental
     */
    static fromSigningProfileAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor(signingProfileArn, signingProfileProfileVersionArn) {
                super(scope, id);
                this.signingProfileName = attrs.signingProfileName;
                this.signingProfileVersion = attrs.signingProfileVersion;
                this.signingProfileArn = signingProfileArn;
                this.signingProfileVersionArn = signingProfileProfileVersionArn;
            }
        }
        const signingProfileArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}`,
        });
        const SigningProfileVersionArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}/${attrs.signingProfileVersion}`,
        });
        return new Import(signingProfileArn, SigningProfileVersionArn);
    }
}
exports.SigningProfile = SigningProfile;
_b = JSII_RTTI_SYMBOL_1;
SigningProfile[_b] = { fqn: "monocdk.aws_signer.SigningProfile", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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