import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Platforms that are allowed with signing config.
 *
 * @see https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html
 * @experimental
 */
export declare class Platform {
    /**
     * (experimental) Specification of signature format and signing algorithms for AWS IoT Device.
     *
     * @experimental
     */
    static readonly AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA: Platform;
    /**
     * (experimental) Specification of signature format and signing algorithms for AWS Lambda.
     *
     * @experimental
     */
    static readonly AWS_LAMBDA_SHA384_ECDSA: Platform;
    /**
     * (experimental) Specification of signature format and signing algorithms with SHA1 hash and RSA encryption for Amazon FreeRTOS.
     *
     * @experimental
     */
    static readonly AMAZON_FREE_RTOS_TI_CC3220SF: Platform;
    /**
     * (experimental) Specification of signature format and signing algorithms with SHA256 hash and ECDSA encryption for Amazon FreeRTOS.
     *
     * @experimental
     */
    static readonly AMAZON_FREE_RTOS_DEFAULT: Platform;
    /**
     * (experimental) The id of signing platform.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-signer-signingprofile.html#cfn-signer-signingprofile-platformid
     * @experimental
     */
    readonly platformId: string;
    private constructor();
}
/**
 * (experimental) A Signer Profile.
 *
 * @experimental
 */
export interface ISigningProfile extends IResource {
    /**
     * (experimental) The ARN of the signing profile.
     *
     * @experimental
     * @attribute true
     */
    readonly signingProfileArn: string;
    /**
     * (experimental) The name of signing profile.
     *
     * @experimental
     * @attribute ProfileName
     */
    readonly signingProfileName: string;
    /**
     * (experimental) The version of signing profile.
     *
     * @experimental
     * @attribute ProfileVersion
     */
    readonly signingProfileVersion: string;
    /**
     * (experimental) The ARN of signing profile version.
     *
     * @experimental
     * @attribute ProfileVersionArn
     */
    readonly signingProfileVersionArn: string;
}
/**
 * (experimental) Construction properties for a Signing Profile object.
 *
 * @experimental
 */
export interface SigningProfileProps {
    /**
     * (experimental) The Signing Platform available for signing profile.
     *
     * @see https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html
     * @experimental
     */
    readonly platform: Platform;
    /**
     * (experimental) The validity period for signatures generated using this signing profile.
     *
     * @default - 135 months
     * @experimental
     */
    readonly signatureValidity?: Duration;
    /**
     * (experimental) Physical name of this Signing Profile.
     *
     * @default - Assigned by CloudFormation (recommended).
     * @experimental
     */
    readonly signingProfileName?: string;
}
/**
 * (experimental) A reference to a Signing Profile.
 *
 * @experimental
 */
export interface SigningProfileAttributes {
    /**
     * (experimental) The name of signing profile.
     *
     * @experimental
     */
    readonly signingProfileName: string;
    /**
     * (experimental) The version of signing profile.
     *
     * @experimental
     */
    readonly signingProfileVersion: string;
}
/**
 * (experimental) Defines a Signing Profile.
 *
 * @experimental
 * @resource AWS::Signer::SigningProfile
 */
export declare class SigningProfile extends Resource implements ISigningProfile {
    /**
     * (experimental) Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `SigningProfileAttributes` object.
     * @experimental
     */
    static fromSigningProfileAttributes(scope: Construct, id: string, attrs: SigningProfileAttributes): ISigningProfile;
    /**
     * (experimental) The ARN of the signing profile.
     *
     * @experimental
     */
    readonly signingProfileArn: string;
    /**
     * (experimental) The name of signing profile.
     *
     * @experimental
     */
    readonly signingProfileName: string;
    /**
     * (experimental) The version of signing profile.
     *
     * @experimental
     */
    readonly signingProfileVersion: string;
    /**
     * (experimental) The ARN of signing profile version.
     *
     * @experimental
     */
    readonly signingProfileVersionArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SigningProfileProps);
}
