import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IReceiptRuleAction } from './receipt-rule-action';
import { IReceiptRuleSet } from './receipt-rule-set';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) A receipt rule.
 *
 * @experimental
 */
export interface IReceiptRule extends IResource {
    /**
     * (experimental) The name of the receipt rule.
     *
     * @experimental
     * @attribute true
     */
    readonly receiptRuleName: string;
}
/**
 * (experimental) The type of TLS policy for a receipt rule.
 *
 * @experimental
 */
export declare enum TlsPolicy {
    /**
     * (experimental) Do not check for TLS.
     *
     * @experimental
     */
    OPTIONAL = "Optional",
    /**
     * (experimental) Bounce emails that are not received over TLS.
     *
     * @experimental
     */
    REQUIRE = "Require"
}
/**
 * (experimental) Options to add a receipt rule to a receipt rule set.
 *
 * @experimental
 */
export interface ReceiptRuleOptions {
    /**
     * (experimental) An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
     *
     * @default - No actions.
     * @experimental
     */
    readonly actions?: IReceiptRuleAction[];
    /**
     * (experimental) An existing rule after which the new rule will be placed.
     *
     * @default - The new rule is inserted at the beginning of the rule list.
     * @experimental
     */
    readonly after?: IReceiptRule;
    /**
     * (experimental) Whether the rule is active.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) The name for the rule.
     *
     * @default - A CloudFormation generated name.
     * @experimental
     */
    readonly receiptRuleName?: string;
    /**
     * (experimental) The recipient domains and email addresses that the receipt rule applies to.
     *
     * @default - Match all recipients under all verified domains.
     * @experimental
     */
    readonly recipients?: string[];
    /**
     * (experimental) Whether to scan for spam and viruses.
     *
     * @default false
     * @experimental
     */
    readonly scanEnabled?: boolean;
    /**
     * (experimental) Whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS).
     *
     * @default - Optional which will not check for TLS.
     * @experimental
     */
    readonly tlsPolicy?: TlsPolicy;
}
/**
 * (experimental) Construction properties for a ReceiptRule.
 *
 * @experimental
 */
export interface ReceiptRuleProps extends ReceiptRuleOptions {
    /**
     * (experimental) The name of the rule set that the receipt rule will be added to.
     *
     * @experimental
     */
    readonly ruleSet: IReceiptRuleSet;
}
/**
 * (experimental) A new receipt rule.
 *
 * @experimental
 */
export declare class ReceiptRule extends Resource implements IReceiptRule {
    /**
     * @experimental
     */
    static fromReceiptRuleName(scope: Construct, id: string, receiptRuleName: string): IReceiptRule;
    /**
     * (experimental) The name of the receipt rule.
     *
     * @experimental
     */
    readonly receiptRuleName: string;
    private readonly actions;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ReceiptRuleProps);
    /**
     * (experimental) Adds an action to this receipt rule.
     *
     * @experimental
     */
    addAction(action: IReceiptRuleAction): void;
    private renderActions;
}
/**
 * @experimental
 */
export interface DropSpamReceiptRuleProps extends ReceiptRuleProps {
}
/**
 * (experimental) A rule added at the top of the rule set to drop spam/virus.
 *
 * @see https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html
 * @experimental
 */
export declare class DropSpamReceiptRule extends CoreConstruct {
    /**
     * @experimental
     */
    readonly rule: ReceiptRule;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DropSpamReceiptRuleProps);
}
