import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { ReceiptRule, ReceiptRuleOptions } from './receipt-rule';
/**
 * (experimental) A receipt rule set.
 *
 * @experimental
 */
export interface IReceiptRuleSet extends IResource {
    /**
     * (experimental) The receipt rule set name.
     *
     * @experimental
     * @attribute true
     */
    readonly receiptRuleSetName: string;
    /**
     * (experimental) Adds a new receipt rule in this rule set.
     *
     * The new rule is added after
     * the last added rule unless `after` is specified.
     *
     * @experimental
     */
    addRule(id: string, options?: ReceiptRuleOptions): ReceiptRule;
}
/**
 * (experimental) Construction properties for a ReceiptRuleSet.
 *
 * @experimental
 */
export interface ReceiptRuleSetProps {
    /**
     * (experimental) The name for the receipt rule set.
     *
     * @default - A CloudFormation generated name.
     * @experimental
     */
    readonly receiptRuleSetName?: string;
    /**
     * (experimental) The list of rules to add to this rule set.
     *
     * Rules are added in the same
     * order as they appear in the list.
     *
     * @default - No rules are added to the rule set.
     * @experimental
     */
    readonly rules?: ReceiptRuleOptions[];
    /**
     * (experimental) Whether to add a first rule to stop processing messages that have at least one spam indicator.
     *
     * @default false
     * @experimental
     */
    readonly dropSpam?: boolean;
}
/**
 * A new or imported receipt rule set.
 */
declare abstract class ReceiptRuleSetBase extends Resource implements IReceiptRuleSet {
    abstract readonly receiptRuleSetName: string;
    private lastAddedRule?;
    /**
     * (experimental) Adds a new receipt rule in this rule set.
     *
     * The new rule is added after
     * the last added rule unless `after` is specified.
     *
     * @experimental
     */
    addRule(id: string, options?: ReceiptRuleOptions): ReceiptRule;
    /**
     * (experimental) Adds a drop spam rule.
     *
     * @experimental
     */
    protected addDropSpamRule(): void;
}
/**
 * (experimental) A new receipt rule set.
 *
 * @experimental
 */
export declare class ReceiptRuleSet extends ReceiptRuleSetBase {
    /**
     * (experimental) Import an exported receipt rule set.
     *
     * @experimental
     */
    static fromReceiptRuleSetName(scope: Construct, id: string, receiptRuleSetName: string): IReceiptRuleSet;
    /**
     * (experimental) The receipt rule set name.
     *
     * @experimental
     */
    readonly receiptRuleSetName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ReceiptRuleSetProps);
}
export {};
