import { IReceiptRule } from './receipt-rule';
/**
 * (experimental) An abstract action for a receipt rule.
 *
 * @experimental
 */
export interface IReceiptRuleAction {
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(receiptRule: IReceiptRule): ReceiptRuleActionConfig;
}
/**
 * (experimental) AddHeaderAction configuration.
 *
 * @experimental
 */
export interface AddHeaderActionConfig {
    /**
     * (experimental) The name of the header that you want to add to the incoming message.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headername
     */
    readonly headerName: string;
    /**
     * (experimental) The content that you want to include in the header.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headervalue
     */
    readonly headerValue: string;
}
/**
 * (experimental) BoundAction configuration.
 *
 * @experimental
 */
export interface BounceActionConfig {
    /**
     * (experimental) Human-readable text to include in the bounce message.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-message
     */
    readonly message: string;
    /**
     * (experimental) The email address of the sender of the bounced email.
     *
     * This is the address that the bounce message is sent from.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-sender
     */
    readonly sender: string;
    /**
     * (experimental) The SMTP reply code, as defined by RFC 5321.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-smtpreplycode
     */
    readonly smtpReplyCode: string;
    /**
     * (experimental) The SMTP enhanced status code, as defined by RFC 3463.
     *
     * @default - No status code.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-statuscode
     */
    readonly statusCode?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) LambdaAction configuration.
 *
 * @experimental
 */
export interface LambdaActionConfig {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the AWS Lambda function.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-functionarn
     */
    readonly functionArn: string;
    /**
     * (experimental) The invocation type of the AWS Lambda function.
     *
     * @default 'Event'
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-invocationtype
     */
    readonly invocationType?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is executed.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) S3Action configuration.
 *
 * @experimental
 */
export interface S3ActionConfig {
    /**
     * (experimental) The name of the Amazon S3 bucket that you want to send incoming mail to.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-bucketname
     */
    readonly bucketName: string;
    /**
     * (experimental) The customer master key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket.
     *
     * @default - Emails are not encrypted.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-kmskeyarn
     */
    readonly kmsKeyArn?: string;
    /**
     * (experimental) The key prefix of the Amazon S3 bucket.
     *
     * @default - No prefix.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-objectkeyprefix
     */
    readonly objectKeyPrefix?: string;
    /**
     * (experimental) The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) SNSAction configuration.
 *
 * @experimental
 */
export interface SNSActionConfig {
    /**
     * (experimental) The encoding to use for the email within the Amazon SNS notification.
     *
     * @default 'UTF-8'
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-encoding
     */
    readonly encoding?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon SNS topic to notify.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) StopAction configuration.
 *
 * @experimental
 */
export interface StopActionConfig {
    /**
     * (experimental) The scope of the StopAction.
     *
     * The only acceptable value is RuleSet.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-scope
     */
    readonly scope: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) WorkmailAction configuration.
 *
 * @experimental
 */
export interface WorkmailActionConfig {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon WorkMail organization.
     *
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-organizationarn
     */
    readonly organizationArn: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
     *
     * @default - No notification is sent to SNS.
     * @experimental
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * (experimental) Properties for a receipt rule action.
 *
 * @experimental
 */
export interface ReceiptRuleActionConfig {
    /**
     * (experimental) Adds a header to the received email.
     *
     * @experimental
     */
    readonly addHeaderAction?: AddHeaderActionConfig;
    /**
     * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly bounceAction?: BounceActionConfig;
    /**
     * (experimental) Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly lambdaAction?: LambdaActionConfig;
    /**
     * (experimental) Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly s3Action?: S3ActionConfig;
    /**
     * (experimental) Publishes the email content within a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly snsAction?: SNSActionConfig;
    /**
     * (experimental) Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly stopAction?: StopActionConfig;
    /**
     * (experimental) Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
     *
     * @experimental
     */
    readonly workmailAction?: WorkmailActionConfig;
}
