import { Resource } from "../../core";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The policy for the receipt filter.
 *
 * @experimental
 */
export declare enum ReceiptFilterPolicy {
    /**
     * (experimental) Allow the ip address or range.
     *
     * @experimental
     */
    ALLOW = "Allow",
    /**
     * (experimental) Block the ip address or range.
     *
     * @experimental
     */
    BLOCK = "Block"
}
/**
 * (experimental) Construction properties for a ReceiptFilter.
 *
 * @experimental
 */
export interface ReceiptFilterProps {
    /**
     * (experimental) The name for the receipt filter.
     *
     * @default a CloudFormation generated name
     * @experimental
     */
    readonly receiptFilterName?: string;
    /**
     * (experimental) The ip address or range to filter.
     *
     * @default 0.0.0.0/0
     * @experimental
     */
    readonly ip?: string;
    /**
     * (experimental) The policy for the filter.
     *
     * @default Block
     * @experimental
     */
    readonly policy?: ReceiptFilterPolicy;
}
/**
 * (experimental) A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @experimental
 */
export declare class ReceiptFilter extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ReceiptFilterProps);
}
/**
 * (experimental) Construction properties for am AllowListReceiptFilter.
 *
 * @experimental
 */
export interface AllowListReceiptFilterProps {
    /**
     * (experimental) A list of ip addresses or ranges to allow list.
     *
     * @experimental
     */
    readonly ips: string[];
}
/**
 * (experimental) An allow list receipt filter.
 *
 * @experimental
 */
export declare class AllowListReceiptFilter extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AllowListReceiptFilterProps);
}
/**
 * (deprecated) Construction properties for a WhiteListReceiptFilter.
 *
 * @deprecated use `AllowListReceiptFilterProps`
 */
export interface WhiteListReceiptFilterProps extends AllowListReceiptFilterProps {
}
/**
 * (deprecated) An allow list receipt filter.
 *
 * @deprecated use `AllowListReceiptFilter`
 */
export declare class WhiteListReceiptFilter extends AllowListReceiptFilter {
    /**
     * @deprecated
     */
    constructor(scope: Construct, id: string, props: WhiteListReceiptFilterProps);
}
