"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
// Adapted from https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html
async function handler(event) {
    console.log('Spam filter');
    const sesNotification = event.Records[0].ses;
    console.log('SES Notification: %j', sesNotification);
    // Check if any spam check failed
    if (sesNotification.receipt.spfVerdict.status === 'FAIL'
        || sesNotification.receipt.dkimVerdict.status === 'FAIL'
        || sesNotification.receipt.spamVerdict.status === 'FAIL'
        || sesNotification.receipt.virusVerdict.status === 'FAIL') {
        console.log('Dropping spam');
        // Stop processing rule set, dropping message
        return { disposition: 'STOP_RULE_SET' };
    }
    return null;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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