"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lambda = exports.LambdaInvocationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) The type of invocation to use for a Lambda Action.
 *
 * @experimental
 */
var LambdaInvocationType;
(function (LambdaInvocationType) {
    LambdaInvocationType["EVENT"] = "Event";
    LambdaInvocationType["REQUEST_RESPONSE"] = "RequestResponse";
})(LambdaInvocationType = exports.LambdaInvocationType || (exports.LambdaInvocationType = {}));
/**
 * (experimental) Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Lambda {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        // Allow SES to invoke Lambda function
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-lambda
        const permissionId = 'AllowSes';
        if (!this.props.function.permissionsNode.tryFindChild(permissionId)) {
            this.props.function.addPermission(permissionId, {
                action: 'lambda:InvokeFunction',
                principal: new iam.ServicePrincipal('ses.amazonaws.com'),
                sourceAccount: cdk.Aws.ACCOUNT_ID,
            });
        }
        // Ensure permission is deployed before rule
        const permission = this.props.function.permissionsNode.tryFindChild(permissionId);
        if (permission) { // The Lambda could be imported
            rule.node.addDependency(permission);
        }
        else {
            // eslint-disable-next-line max-len
            cdk.Annotations.of(rule).addWarning('This rule is using a Lambda action with an imported function. Ensure permission is given to SES to invoke that function.');
        }
        return {
            lambdaAction: {
                functionArn: this.props.function.functionArn,
                invocationType: this.props.invocationType,
                topicArn: (_b = this.props.topic) === null || _b === void 0 ? void 0 : _b.topicArn,
            },
        };
    }
}
exports.Lambda = Lambda;
_a = JSII_RTTI_SYMBOL_1;
Lambda[_a] = { fqn: "monocdk.aws_ses_actions.Lambda", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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