"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) A bounce template.
 *
 * @experimental
 */
class BounceTemplate {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "monocdk.aws_ses_actions.BounceTemplate", version: "1.106.1" };
/**
 * @experimental
 */
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
/**
 * @experimental
 */
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
/**
 * @experimental
 */
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Bounce {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule) {
        var _c;
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "monocdk.aws_ses_actions.Bounce", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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