import * as ses from "../../aws-ses";
import * as sns from "../../aws-sns";
/**
 * (experimental) Construction properties for a BounceTemplate.
 *
 * @experimental
 */
export interface BounceTemplateProps {
    /**
     * (experimental) Human-readable text to include in the bounce message.
     *
     * @experimental
     */
    readonly message: string;
    /**
     * (experimental) The SMTP reply code, as defined by RFC 5321.
     *
     * @see https://tools.ietf.org/html/rfc5321
     * @experimental
     */
    readonly smtpReplyCode: string;
    /**
     * (experimental) The SMTP enhanced status code, as defined by RFC 3463.
     *
     * @see https://tools.ietf.org/html/rfc3463
     * @experimental
     */
    readonly statusCode?: string;
}
/**
 * (experimental) A bounce template.
 *
 * @experimental
 */
export declare class BounceTemplate {
    readonly props: BounceTemplateProps;
    /**
     * @experimental
     */
    static readonly MAILBOX_DOES_NOT_EXIST: BounceTemplate;
    /**
     * @experimental
     */
    static readonly MESSAGE_TOO_LARGE: BounceTemplate;
    /**
     * @experimental
     */
    static readonly MAILBOX_FULL: BounceTemplate;
    /**
     * @experimental
     */
    static readonly MESSAGE_CONTENT_REJECTED: BounceTemplate;
    /**
     * @experimental
     */
    static readonly TEMPORARY_FAILURE: BounceTemplate;
    /**
     * @experimental
     */
    constructor(props: BounceTemplateProps);
}
/**
 * (experimental) Construction properties for a bounce action.
 *
 * @experimental
 */
export interface BounceProps {
    /**
     * (experimental) The template containing the message, reply code and status code.
     *
     * @experimental
     */
    readonly template: BounceTemplate;
    /**
     * (experimental) The email address of the sender of the bounced email.
     *
     * This is the address
     * from which the bounce message will be sent.
     *
     * @experimental
     */
    readonly sender: string;
    /**
     * (experimental) The SNS topic to notify when the bounce action is taken.
     *
     * @default no notification
     * @experimental
     */
    readonly topic?: sns.ITopic;
}
/**
 * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
export declare class Bounce implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: BounceProps);
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
