"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Adds a header to the received email.
 *
 * @experimental
 */
class AddHeader {
    /**
     * @experimental
     */
    constructor(props) {
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // eslint-disable-next-line max-len
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
_a = JSII_RTTI_SYMBOL_1;
AddHeader[_a] = { fqn: "monocdk.aws_ses_actions.AddHeader", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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