import * as ec2 from "../../aws-ec2";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { DnsServiceProps, Service } from './service';
/**
 * @experimental
 */
export interface PrivateDnsNamespaceProps extends BaseNamespaceProps {
    /**
     * (experimental) The Amazon VPC that you want to associate the namespace with.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
}
/**
 * @experimental
 */
export interface IPrivateDnsNamespace extends INamespace {
}
/**
 * @experimental
 */
export interface PrivateDnsNamespaceAttributes {
    /**
     * (experimental) A name for the Namespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the Namespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace ARN for the Namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
}
/**
 * (experimental) Define a Service Discovery HTTP Namespace.
 *
 * @experimental
 */
export declare class PrivateDnsNamespace extends Resource implements IPrivateDnsNamespace {
    /**
     * @experimental
     */
    static fromPrivateDnsNamespaceAttributes(scope: Construct, id: string, attrs: PrivateDnsNamespaceAttributes): IPrivateDnsNamespace;
    /**
     * (experimental) The name of the PrivateDnsNamespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id of the PrivateDnsNamespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace Arn of the namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
    /**
     * (experimental) Type of the namespace.
     *
     * @experimental
     */
    readonly type: NamespaceType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PrivateDnsNamespaceProps);
    /**
     * @experimental
     * @attribute true
     */
    get privateDnsNamespaceArn(): string;
    /**
     * @experimental
     * @attribute true
     */
    get privateDnsNamespaceName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get privateDnsNamespaceId(): string;
    /**
     * (experimental) Creates a service within the namespace.
     *
     * @experimental
     */
    createService(id: string, props?: DnsServiceProps): Service;
}
