import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @experimental
 */
export interface NonIpInstanceBaseProps extends BaseInstanceProps {
}
/**
 * @experimental
 */
export interface NonIpInstanceProps extends NonIpInstanceBaseProps {
    /**
     * (experimental) The Cloudmap service this resource is registered to.
     *
     * @experimental
     */
    readonly service: IService;
}
/**
 * (experimental) Instance accessible using values other than an IP address or a domain name (CNAME).
 *
 * Specify the other values in Custom attributes.
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class NonIpInstance extends InstanceBase {
    /**
     * (experimental) The Id of the instance.
     *
     * @experimental
     */
    readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service to which the instance is registered.
     *
     * @experimental
     */
    readonly service: IService;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NonIpInstanceProps);
}
