import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @experimental
 */
export interface IpInstanceBaseProps extends BaseInstanceProps {
    /**
     * (experimental) The port on the endpoint that you want AWS Cloud Map to perform health checks on.
     *
     * This value is also used for
     * the port value in an SRV record if the service that you specify includes an SRV record. You can also specify a
     * default port that is applied to all instances in the Service configuration.
     *
     * @default 80
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record.
     *
     * @default none
     * @experimental
     */
    readonly ipv4?: string;
    /**
     * (experimental) If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record.
     *
     * @default none
     * @experimental
     */
    readonly ipv6?: string;
}
/**
 * @experimental
 */
export interface IpInstanceProps extends IpInstanceBaseProps {
    /**
     * (experimental) The Cloudmap service this resource is registered to.
     *
     * @experimental
     */
    readonly service: IService;
}
/**
 * (experimental) Instance that is accessible using an IP address.
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class IpInstance extends InstanceBase {
    /**
     * (experimental) The Id of the instance.
     *
     * @experimental
     */
    readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service to which the instance is registered.
     *
     * @experimental
     */
    readonly service: IService;
    /**
     * (experimental) The Ipv4 address of the instance, or blank string if none available.
     *
     * @experimental
     */
    readonly ipv4: string;
    /**
     * (experimental) The Ipv6 address of the instance, or blank string if none available.
     *
     * @experimental
     */
    readonly ipv6: string;
    /**
     * (experimental) The exposed port of the instance.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: IpInstanceProps);
}
