import { IResource, Resource } from "../../core";
import { IService } from './service';
/**
 * @experimental
 */
export interface IInstance extends IResource {
    /**
     * (experimental) The id of the instance resource.
     *
     * @experimental
     * @attribute true
     */
    readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service this resource is registered to.
     *
     * @experimental
     */
    readonly service: IService;
}
/**
 * (experimental) Used when the resource that's associated with the service instance is accessible using values other than an IP address or a domain name (CNAME), i.e. for non-ip-instances.
 *
 * @experimental
 */
export interface BaseInstanceProps {
    /**
     * (experimental) The id of the instance resource.
     *
     * @default Automatically generated name
     * @experimental
     */
    readonly instanceId?: string;
    /**
     * (experimental) Custom attributes of the instance.
     *
     * @default none
     * @experimental
     */
    readonly customAttributes?: {
        [key: string]: string;
    };
}
/**
 * @experimental
 */
export declare abstract class InstanceBase extends Resource implements IInstance {
    /**
     * (experimental) The Id of the instance.
     *
     * @experimental
     */
    abstract readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service to which the instance is registered.
     *
     * @experimental
     */
    abstract readonly service: IService;
    /**
     * (experimental) Generate a unique instance Id that is safe to pass to CloudMap.
     *
     * @experimental
     */
    protected uniqueInstanceId(): string;
}
