import { Resource } from "../../core";
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { BaseServiceProps, Service } from './service';
/**
 * @experimental
 */
export interface HttpNamespaceProps extends BaseNamespaceProps {
}
/**
 * @experimental
 */
export interface IHttpNamespace extends INamespace {
}
/**
 * @experimental
 */
export interface HttpNamespaceAttributes {
    /**
     * (experimental) A name for the Namespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the Namespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace ARN for the Namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
}
/**
 * (experimental) Define an HTTP Namespace.
 *
 * @experimental
 */
export declare class HttpNamespace extends Resource implements IHttpNamespace {
    /**
     * @experimental
     */
    static fromHttpNamespaceAttributes(scope: Construct, id: string, attrs: HttpNamespaceAttributes): IHttpNamespace;
    /**
     * (experimental) A name for the namespace.
     *
     * @experimental
     */
    readonly namespaceName: string;
    /**
     * (experimental) Namespace Id for the namespace.
     *
     * @experimental
     */
    readonly namespaceId: string;
    /**
     * (experimental) Namespace Arn for the namespace.
     *
     * @experimental
     */
    readonly namespaceArn: string;
    /**
     * (experimental) Type of the namespace.
     *
     * @experimental
     */
    readonly type: NamespaceType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpNamespaceProps);
    /**
     * @experimental
     * @attribute true
     */
    get httpNamespaceArn(): string;
    /**
     * @experimental
     * @attribute true
     */
    get httpNamespaceName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get httpNamespaceId(): string;
    /**
     * (experimental) Creates a service within the namespace.
     *
     * @experimental
     */
    createService(id: string, props?: BaseServiceProps): Service;
}
