import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @experimental
 */
export interface CnameInstanceBaseProps extends BaseInstanceProps {
    /**
     * (experimental) If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in response to DNS queries, for example, example.com. This value is required if the service specified by ServiceId includes settings for an CNAME record.
     *
     * @experimental
     */
    readonly instanceCname: string;
}
/**
 * @experimental
 */
export interface CnameInstanceProps extends CnameInstanceBaseProps {
    /**
     * (experimental) The Cloudmap service this resource is registered to.
     *
     * @experimental
     */
    readonly service: IService;
}
/**
 * (experimental) Instance that is accessible using a domain name (CNAME).
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class CnameInstance extends InstanceBase {
    /**
     * (experimental) The Id of the instance.
     *
     * @experimental
     */
    readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service to which the instance is registered.
     *
     * @experimental
     */
    readonly service: IService;
    /**
     * (experimental) The domain name returned by DNS queries for the instance.
     *
     * @experimental
     */
    readonly cname: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CnameInstanceProps);
}
