"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasTargetInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * (experimental) Instance that uses Route 53 Alias record type.
 *
 * Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
class AliasTargetInstance extends instance_1.InstanceBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        // Should already be enforced when creating service, but validates if service is not instantiated with #createService
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType !== service_1.DnsRecordType.A
            && dnsRecordType !== service_1.DnsRecordType.AAAA
            && dnsRecordType !== service_1.DnsRecordType.A_AAAA) {
            throw new Error('Service must use `A` or `AAAA` records to register an AliasRecordTarget.');
        }
        if (props.service.routingPolicy !== service_1.RoutingPolicy.WEIGHTED) {
            throw new Error('Service must use `WEIGHTED` routing policy.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_ALIAS_DNS_NAME: props.dnsName,
                ...props.customAttributes,
            },
            instanceId: props.instanceId || core_1.Names.uniqueId(this),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.dnsName = props.dnsName;
    }
}
exports.AliasTargetInstance = AliasTargetInstance;
_a = JSII_RTTI_SYMBOL_1;
AliasTargetInstance[_a] = { fqn: "monocdk.aws_servicediscovery.AliasTargetInstance", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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