import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @experimental
 */
export interface AliasTargetInstanceProps extends BaseInstanceProps {
    /**
     * (experimental) DNS name of the target.
     *
     * @experimental
     */
    readonly dnsName: string;
    /**
     * (experimental) The Cloudmap service this resource is registered to.
     *
     * @experimental
     */
    readonly service: IService;
}
/**
 * (experimental) Instance that uses Route 53 Alias record type.
 *
 * Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @experimental
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class AliasTargetInstance extends InstanceBase {
    /**
     * (experimental) The Id of the instance.
     *
     * @experimental
     */
    readonly instanceId: string;
    /**
     * (experimental) The Cloudmap service to which the instance is registered.
     *
     * @experimental
     */
    readonly service: IService;
    /**
     * (experimental) The Route53 DNS name of the alias target.
     *
     * @experimental
     */
    readonly dnsName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AliasTargetInstanceProps);
}
