import * as ec2 from "../../aws-ec2";
import * as lambda from "../../aws-lambda";
import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
import { ISecret } from './secret';
import { CfnRotationSchedule } from './secretsmanager.generated';
/**
 * (experimental) Options to add a rotation schedule to a secret.
 *
 * @experimental
 */
export interface RotationScheduleOptions {
    /**
     * (experimental) A Lambda function that can rotate the secret.
     *
     * @default - either `rotationLambda` or `hostedRotation` must be specified
     * @experimental
     */
    readonly rotationLambda?: lambda.IFunction;
    /**
     * (experimental) Hosted rotation.
     *
     * @default - either `rotationLambda` or `hostedRotation` must be specified
     * @experimental
     */
    readonly hostedRotation?: HostedRotation;
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
}
/**
 * (experimental) Construction properties for a RotationSchedule.
 *
 * @experimental
 */
export interface RotationScheduleProps extends RotationScheduleOptions {
    /**
     * (experimental) The secret to rotate.
     *
     * If hosted rotation is used, this must be a JSON string with the following format:
     *
     * ```
     * {
     *    "engine": <required: database engine>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port will be used>,
     *    "masterarn": <required for multi user rotation: the arn of the master secret which will be used to create users/change passwords>
     * }
     * ```
     *
     * This is typically the case for a secret referenced from an `AWS::SecretsManager::SecretTargetAttachment`
     * or an `ISecret` returned by the `attach()` method of `Secret`.
     *
     * @experimental
     */
    readonly secret: ISecret;
}
/**
 * (experimental) A rotation schedule.
 *
 * @experimental
 */
export declare class RotationSchedule extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RotationScheduleProps);
}
/**
 * (experimental) Single user hosted rotation options.
 *
 * @experimental
 */
export interface SingleUserHostedRotationOptions {
    /**
     * (experimental) A name for the Lambda created to rotate the secret.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly functionName?: string;
    /**
     * (experimental) A list of security groups for the Lambda created to rotate the secret.
     *
     * @default - a new security group is created
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The VPC where the Lambda rotation function will run.
     *
     * @default - the Lambda is not deployed in a VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The type of subnets in the VPC where the Lambda rotation function will run.
     *
     * @default - the Vpc default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
}
/**
 * (experimental) Multi user hosted rotation options.
 *
 * @experimental
 */
export interface MultiUserHostedRotationOptions extends SingleUserHostedRotationOptions {
    /**
     * (experimental) The master secret for a multi user rotation scheme.
     *
     * @experimental
     */
    readonly masterSecret: ISecret;
}
/**
 * (experimental) A hosted rotation.
 *
 * @experimental
 */
export declare class HostedRotation implements ec2.IConnectable {
    private readonly type;
    private readonly props;
    private readonly masterSecret?;
    /**
     * (experimental) MySQL Single User.
     *
     * @experimental
     */
    static mysqlSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) MySQL Multi User.
     *
     * @experimental
     */
    static mysqlMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) PostgreSQL Single User.
     *
     * @experimental
     */
    static postgreSqlSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) PostgreSQL Multi User.
     *
     * @experimental
     */
    static postgreSqlMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) Oracle Single User.
     *
     * @experimental
     */
    static oracleSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) Oracle Multi User.
     *
     * @experimental
     */
    static oracleMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) MariaDB Single User.
     *
     * @experimental
     */
    static mariaDbSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) MariaDB Multi User.
     *
     * @experimental
     */
    static mariaDbMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) SQL Server Single User.
     *
     * @experimental
     */
    static sqlServerSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) SQL Server Multi User.
     *
     * @experimental
     */
    static sqlServerMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) Redshift Single User.
     *
     * @experimental
     */
    static redshiftSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) Redshift Multi User.
     *
     * @experimental
     */
    static redshiftMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) MongoDB Single User.
     *
     * @experimental
     */
    static mongoDbSingleUser(options?: SingleUserHostedRotationOptions): HostedRotation;
    /**
     * (experimental) MongoDB Multi User.
     *
     * @experimental
     */
    static mongoDbMultiUser(options: MultiUserHostedRotationOptions): HostedRotation;
    private _connections?;
    private constructor();
    /**
     * (experimental) Binds this hosted rotation to a secret.
     *
     * @experimental
     */
    bind(secret: ISecret, scope: Construct): CfnRotationSchedule.HostedRotationLambdaProperty;
    /**
     * (experimental) Security group connections for this hosted rotation.
     *
     * @experimental
     */
    get connections(): ec2.Connections;
}
/**
 * (experimental) Hosted rotation type.
 *
 * @experimental
 */
export declare class HostedRotationType {
    readonly name: string;
    readonly isMultiUser?: boolean | undefined;
    /**
     * (experimental) MySQL Single User.
     *
     * @experimental
     */
    static readonly MYSQL_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) MySQL Multi User.
     *
     * @experimental
     */
    static readonly MYSQL_MULTI_USER: HostedRotationType;
    /**
     * (experimental) PostgreSQL Single User.
     *
     * @experimental
     */
    static readonly POSTGRESQL_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) PostgreSQL Multi User.
     *
     * @experimental
     */
    static readonly POSTGRESQL_MULTI_USER: HostedRotationType;
    /**
     * (experimental) Oracle Single User.
     *
     * @experimental
     */
    static readonly ORACLE_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) Oracle Multi User.
     *
     * @experimental
     */
    static readonly ORACLE_MULTI_USER: HostedRotationType;
    /**
     * (experimental) MariaDB Single User.
     *
     * @experimental
     */
    static readonly MARIADB_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) MariaDB Multi User.
     *
     * @experimental
     */
    static readonly MARIADB_MULTI_USER: HostedRotationType;
    /**
     * (experimental) SQL Server Single User.
     *
     * @experimental
     */
    static readonly SQLSERVER_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) SQL Server Multi User.
     *
     * @experimental
     */
    static readonly SQLSERVER_MULTI_USER: HostedRotationType;
    /**
     * (experimental) Redshift Single User.
     *
     * @experimental
     */
    static readonly REDSHIFT_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) Redshift Multi User.
     *
     * @experimental
     */
    static readonly REDSHIFT_MULTI_USER: HostedRotationType;
    /**
     * (experimental) MongoDB Single User.
     *
     * @experimental
     */
    static readonly MONGODB_SINGLE_USER: HostedRotationType;
    /**
     * (experimental) MongoDB Multi User.
     *
     * @experimental
     */
    static readonly MONGODB_MULTI_USER: HostedRotationType;
    /**
     * @param name The type of rotation
     * @param isMultiUser Whether the rotation uses the mutli user scheme
     */
    private constructor();
}
