import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::SageMaker::App`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::SageMaker::App.AppName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
     */
    readonly appName: string;
    /**
     * `AWS::SageMaker::App.AppType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
     */
    readonly appType: string;
    /**
     * `AWS::SageMaker::App.DomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
     */
    readonly domainId: string;
    /**
     * `AWS::SageMaker::App.UserProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
     */
    readonly userProfileName: string;
    /**
     * `AWS::SageMaker::App.ResourceSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
     */
    readonly resourceSpec?: CfnApp.ResourceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::App`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApp;
    /**
     * @external
     * @cloudformationAttribute AppArn
     */
    readonly attrAppArn: string;
    /**
     * `AWS::SageMaker::App.AppName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
     */
    appName: string;
    /**
     * `AWS::SageMaker::App.AppType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
     */
    appType: string;
    /**
     * `AWS::SageMaker::App.DomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
     */
    domainId: string;
    /**
     * `AWS::SageMaker::App.UserProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
     */
    userProfileName: string;
    /**
     * `AWS::SageMaker::App.ResourceSpec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
     */
    resourceSpec: CfnApp.ResourceSpecProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::App`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html
     */
    interface ResourceSpecProperty {
        /**
         * `CfnApp.ResourceSpecProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnApp.ResourceSpecProperty.SageMakerImageArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimagearn
         */
        readonly sageMakerImageArn?: string;
        /**
         * `CfnApp.ResourceSpecProperty.SageMakerImageVersionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimageversionarn
         */
        readonly sageMakerImageVersionArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::AppImageConfig`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
export interface CfnAppImageConfigProps {
    /**
     * `AWS::SageMaker::AppImageConfig.AppImageConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
     */
    readonly appImageConfigName: string;
    /**
     * `AWS::SageMaker::AppImageConfig.KernelGatewayImageConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
     */
    readonly kernelGatewayImageConfig?: CfnAppImageConfig.KernelGatewayImageConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::AppImageConfig.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::AppImageConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::AppImageConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
export declare class CfnAppImageConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::AppImageConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAppImageConfig;
    /**
     * @external
     * @cloudformationAttribute AppImageConfigArn
     */
    readonly attrAppImageConfigArn: string;
    /**
     * `AWS::SageMaker::AppImageConfig.AppImageConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
     */
    appImageConfigName: string;
    /**
     * `AWS::SageMaker::AppImageConfig.KernelGatewayImageConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
     */
    kernelGatewayImageConfig: CfnAppImageConfig.KernelGatewayImageConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::AppImageConfig.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::AppImageConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppImageConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::AppImageConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::AppImageConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
export declare namespace CfnAppImageConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnAppImageConfig.FileSystemConfigProperty.DefaultGid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid
         */
        readonly defaultGid?: number;
        /**
         * `CfnAppImageConfig.FileSystemConfigProperty.DefaultUid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid
         */
        readonly defaultUid?: number;
        /**
         * `CfnAppImageConfig.FileSystemConfigProperty.MountPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath
         */
        readonly mountPath?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::AppImageConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::AppImageConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
export declare namespace CfnAppImageConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html
     */
    interface KernelGatewayImageConfigProperty {
        /**
         * `CfnAppImageConfig.KernelGatewayImageConfigProperty.FileSystemConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig
         */
        readonly fileSystemConfig?: CfnAppImageConfig.FileSystemConfigProperty | cdk.IResolvable;
        /**
         * `CfnAppImageConfig.KernelGatewayImageConfigProperty.KernelSpecs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs
         */
        readonly kernelSpecs: Array<CfnAppImageConfig.KernelSpecProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::AppImageConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::AppImageConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
export declare namespace CfnAppImageConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html
     */
    interface KernelSpecProperty {
        /**
         * `CfnAppImageConfig.KernelSpecProperty.DisplayName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname
         */
        readonly displayName?: string;
        /**
         * `CfnAppImageConfig.KernelSpecProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name
         */
        readonly name: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export interface CfnCodeRepositoryProps {
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    readonly gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    readonly codeRepositoryName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export declare class CfnCodeRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCodeRepository;
    /**
     * @external
     * @cloudformationAttribute CodeRepositoryName
     */
    readonly attrCodeRepositoryName: string;
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    codeRepositoryName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export declare namespace CfnCodeRepository {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     */
    interface GitConfigProperty {
        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         */
        readonly branch?: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         */
        readonly repositoryUrl: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         */
        readonly secretArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export interface CfnDataQualityJobDefinitionProps {
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
     */
    readonly dataQualityAppSpecification: CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
     */
    readonly dataQualityJobInput: CfnDataQualityJobDefinition.DataQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
     */
    readonly dataQualityJobOutputConfig: CfnDataQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
     */
    readonly jobResources: CfnDataQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
     */
    readonly dataQualityBaselineConfig?: CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
     */
    readonly networkConfig?: CfnDataQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
     */
    readonly stoppingCondition?: CfnDataQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare class CfnDataQualityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DataQualityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataQualityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
     */
    dataQualityAppSpecification: CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
     */
    dataQualityJobInput: CfnDataQualityJobDefinition.DataQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
     */
    dataQualityJobOutputConfig: CfnDataQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
     */
    jobResources: CfnDataQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
     */
    dataQualityBaselineConfig: CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
     */
    networkConfig: CfnDataQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
     */
    stoppingCondition: CfnDataQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::DataQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataQualityJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnDataQualityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html#cfn-sagemaker-dataqualityjobdefinition-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html
     */
    interface DataQualityAppSpecificationProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ContainerArguments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerarguments
         */
        readonly containerArguments?: string[];
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerentrypoint
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-environment
         */
        readonly environment?: CfnDataQualityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-imageuri
         */
        readonly imageUri: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-postanalyticsprocessorsourceuri
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-recordpreprocessorsourceuri
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html
     */
    interface DataQualityBaselineConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.BaseliningJobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-baseliningjobname
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.ConstraintsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnDataQualityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.StatisticsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-statisticsresource
         */
        readonly statisticsResource?: CfnDataQualityJobDefinition.StatisticsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html
     */
    interface DataQualityJobInputProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityJobInputProperty.EndpointInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-endpointinput
         */
        readonly endpointInput: CfnDataQualityJobDefinition.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-environment.html
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutput-s3output
         */
        readonly s3Output: CfnDataQualityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnDataQualityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html#cfn-sagemaker-dataqualityjobdefinition-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnDataQualityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnDataQualityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnDataQualityJobDefinition.StatisticsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html#cfn-sagemaker-dataqualityjobdefinition-statisticsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnDataQualityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDataQualityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Device`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 */
export interface CfnDeviceProps {
    /**
     * `AWS::SageMaker::Device.DeviceFleetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
     */
    readonly deviceFleetName: string;
    /**
     * `AWS::SageMaker::Device.Device`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
     */
    readonly device?: CfnDevice.DeviceProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Device.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Device`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Device
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 */
export declare class CfnDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Device";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDevice;
    /**
     * `AWS::SageMaker::Device.DeviceFleetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
     */
    deviceFleetName: string;
    /**
     * `AWS::SageMaker::Device.Device`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
     */
    device: CfnDevice.DeviceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Device.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Device`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Device`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Device
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 */
export declare namespace CfnDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html
     */
    interface DeviceProperty {
        /**
         * `CfnDevice.DeviceProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-description
         */
        readonly description?: string;
        /**
         * `CfnDevice.DeviceProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnDevice.DeviceProperty.IotThingName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-iotthingname
         */
        readonly iotThingName?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::DeviceFleet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 */
export interface CfnDeviceFleetProps {
    /**
     * `AWS::SageMaker::DeviceFleet.DeviceFleetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
     */
    readonly deviceFleetName: string;
    /**
     * `AWS::SageMaker::DeviceFleet.OutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
     */
    readonly outputConfig: CfnDeviceFleet.EdgeOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DeviceFleet.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DeviceFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 */
export declare class CfnDeviceFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DeviceFleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeviceFleet;
    /**
     * `AWS::SageMaker::DeviceFleet.DeviceFleetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
     */
    deviceFleetName: string;
    /**
     * `AWS::SageMaker::DeviceFleet.OutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
     */
    outputConfig: CfnDeviceFleet.EdgeOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DeviceFleet.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::DeviceFleet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::DeviceFleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::DeviceFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 */
export declare namespace CfnDeviceFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html
     */
    interface EdgeOutputConfigProperty {
        /**
         * `CfnDeviceFleet.EdgeOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDeviceFleet.EdgeOutputConfigProperty.S3OutputLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-s3outputlocation
         */
        readonly s3OutputLocation: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Domain`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::SageMaker::Domain.AuthMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
     */
    readonly authMode: string;
    /**
     * `AWS::SageMaker::Domain.DefaultUserSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
     */
    readonly defaultUserSettings: CfnDomain.UserSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::SageMaker::Domain.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::SageMaker::Domain.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::SageMaker::Domain.AppNetworkAccessType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
     */
    readonly appNetworkAccessType?: string;
    /**
     * `AWS::SageMaker::Domain.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Domain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomain;
    /**
     * @external
     * @cloudformationAttribute DomainArn
     */
    readonly attrDomainArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainId
     */
    readonly attrDomainId: string;
    /**
     * @external
     * @cloudformationAttribute HomeEfsFileSystemId
     */
    readonly attrHomeEfsFileSystemId: string;
    /**
     * @external
     * @cloudformationAttribute SingleSignOnManagedApplicationInstanceId
     */
    readonly attrSingleSignOnManagedApplicationInstanceId: string;
    /**
     * @external
     * @cloudformationAttribute Url
     */
    readonly attrUrl: string;
    /**
     * `AWS::SageMaker::Domain.AuthMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
     */
    authMode: string;
    /**
     * `AWS::SageMaker::Domain.DefaultUserSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
     */
    defaultUserSettings: CfnDomain.UserSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
     */
    domainName: string;
    /**
     * `AWS::SageMaker::Domain.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::SageMaker::Domain.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
     */
    vpcId: string;
    /**
     * `AWS::SageMaker::Domain.AppNetworkAccessType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
     */
    appNetworkAccessType: string | undefined;
    /**
     * `AWS::SageMaker::Domain.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html
     */
    interface CustomImageProperty {
        /**
         * `CfnDomain.CustomImageProperty.AppImageConfigName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname
         */
        readonly appImageConfigName: string;
        /**
         * `CfnDomain.CustomImageProperty.ImageName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename
         */
        readonly imageName: string;
        /**
         * `CfnDomain.CustomImageProperty.ImageVersionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber
         */
        readonly imageVersionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html
     */
    interface JupyterServerAppSettingsProperty {
        /**
         * `CfnDomain.JupyterServerAppSettingsProperty.DefaultResourceSpec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec
         */
        readonly defaultResourceSpec?: CfnDomain.ResourceSpecProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html
     */
    interface KernelGatewayAppSettingsProperty {
        /**
         * `CfnDomain.KernelGatewayAppSettingsProperty.CustomImages`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages
         */
        readonly customImages?: Array<CfnDomain.CustomImageProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDomain.KernelGatewayAppSettingsProperty.DefaultResourceSpec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec
         */
        readonly defaultResourceSpec?: CfnDomain.ResourceSpecProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html
     */
    interface ResourceSpecProperty {
        /**
         * `CfnDomain.ResourceSpecProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnDomain.ResourceSpecProperty.SageMakerImageArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn
         */
        readonly sageMakerImageArn?: string;
        /**
         * `CfnDomain.ResourceSpecProperty.SageMakerImageVersionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn
         */
        readonly sageMakerImageVersionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html
     */
    interface SharingSettingsProperty {
        /**
         * `CfnDomain.SharingSettingsProperty.NotebookOutputOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption
         */
        readonly notebookOutputOption?: string;
        /**
         * `CfnDomain.SharingSettingsProperty.S3KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid
         */
        readonly s3KmsKeyId?: string;
        /**
         * `CfnDomain.SharingSettingsProperty.S3OutputPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath
         */
        readonly s3OutputPath?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
export declare namespace CfnDomain {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html
     */
    interface UserSettingsProperty {
        /**
         * `CfnDomain.UserSettingsProperty.ExecutionRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole
         */
        readonly executionRole?: string;
        /**
         * `CfnDomain.UserSettingsProperty.JupyterServerAppSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings
         */
        readonly jupyterServerAppSettings?: CfnDomain.JupyterServerAppSettingsProperty | cdk.IResolvable;
        /**
         * `CfnDomain.UserSettingsProperty.KernelGatewayAppSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings
         */
        readonly kernelGatewayAppSettings?: CfnDomain.KernelGatewayAppSettingsProperty | cdk.IResolvable;
        /**
         * `CfnDomain.UserSettingsProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnDomain.UserSettingsProperty.SharingSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings
         */
        readonly sharingSettings?: CfnDomain.SharingSettingsProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export interface CfnEndpointProps {
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    readonly endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.DeploymentConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
     */
    readonly deploymentConfig?: CfnEndpoint.DeploymentConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    readonly excludeRetainedVariantProperties?: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    readonly retainAllVariantProperties?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @external
     * @cloudformationAttribute EndpointName
     */
    readonly attrEndpointName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.DeploymentConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
     */
    deploymentConfig: CfnEndpoint.DeploymentConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    excludeRetainedVariantProperties: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    retainAllVariantProperties: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html
     */
    interface AlarmProperty {
        /**
         * `CfnEndpoint.AlarmProperty.AlarmName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname
         */
        readonly alarmName: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html
     */
    interface AutoRollbackConfigProperty {
        /**
         * `CfnEndpoint.AutoRollbackConfigProperty.Alarms`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms
         */
        readonly alarms: Array<CfnEndpoint.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html
     */
    interface BlueGreenUpdatePolicyProperty {
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.MaximumExecutionTimeoutInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds
         */
        readonly maximumExecutionTimeoutInSeconds?: number;
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.TerminationWaitInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds
         */
        readonly terminationWaitInSeconds?: number;
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.TrafficRoutingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration
         */
        readonly trafficRoutingConfiguration: CfnEndpoint.TrafficRoutingConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html
     */
    interface CapacitySizeProperty {
        /**
         * `CfnEndpoint.CapacitySizeProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type
         */
        readonly type: string;
        /**
         * `CfnEndpoint.CapacitySizeProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html
     */
    interface DeploymentConfigProperty {
        /**
         * `CfnEndpoint.DeploymentConfigProperty.AutoRollbackConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration
         */
        readonly autoRollbackConfiguration?: CfnEndpoint.AutoRollbackConfigProperty | cdk.IResolvable;
        /**
         * `CfnEndpoint.DeploymentConfigProperty.BlueGreenUpdatePolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy
         */
        readonly blueGreenUpdatePolicy: CfnEndpoint.BlueGreenUpdatePolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html
     */
    interface TrafficRoutingConfigProperty {
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.CanarySize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize
         */
        readonly canarySize?: CfnEndpoint.CapacitySizeProperty | cdk.IResolvable;
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type
         */
        readonly type: string;
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.WaitIntervalInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds
         */
        readonly waitIntervalInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare namespace CfnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
     */
    interface VariantPropertyProperty {
        /**
         * `CfnEndpoint.VariantPropertyProperty.VariantPropertyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
         */
        readonly variantPropertyType?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export interface CfnEndpointConfigProps {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    readonly productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    readonly dataCaptureConfig?: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    readonly endpointConfigName?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare class CfnEndpointConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpointConfig;
    /**
     * @external
     * @cloudformationAttribute EndpointConfigName
     */
    readonly attrEndpointConfigName: string;
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    dataCaptureConfig: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    endpointConfigName: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare namespace CfnEndpointConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
     */
    interface CaptureContentTypeHeaderProperty {
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
         */
        readonly csvContentTypes?: string[];
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
         */
        readonly jsonContentTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare namespace CfnEndpointConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
     */
    interface CaptureOptionProperty {
        /**
         * `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
         */
        readonly captureMode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare namespace CfnEndpointConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
     */
    interface DataCaptureConfigProperty {
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
         */
        readonly captureContentTypeHeader?: CfnEndpointConfig.CaptureContentTypeHeaderProperty | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
         */
        readonly captureOptions: Array<CfnEndpointConfig.CaptureOptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
         */
        readonly destinationS3Uri: string;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
         */
        readonly enableCapture?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
         */
        readonly initialSamplingPercentage: number;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare namespace CfnEndpointConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    interface ProductionVariantProperty {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        readonly acceleratorType?: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        readonly initialInstanceCount: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        readonly initialVariantWeight: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        readonly modelName: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        readonly variantName: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::FeatureGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
 */
export interface CfnFeatureGroupProps {
    /**
     * `AWS::SageMaker::FeatureGroup.EventTimeFeatureName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
     */
    readonly eventTimeFeatureName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.FeatureDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
     */
    readonly featureDefinitions: Array<CfnFeatureGroup.FeatureDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::FeatureGroup.FeatureGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
     */
    readonly featureGroupName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.RecordIdentifierFeatureName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
     */
    readonly recordIdentifierFeatureName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::FeatureGroup.OfflineStoreConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
     */
    readonly offlineStoreConfig?: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::FeatureGroup.OnlineStoreConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
     */
    readonly onlineStoreConfig?: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::FeatureGroup.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::SageMaker::FeatureGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::FeatureGroup`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::FeatureGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
 */
export declare class CfnFeatureGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::FeatureGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFeatureGroup;
    /**
     * `AWS::SageMaker::FeatureGroup.EventTimeFeatureName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
     */
    eventTimeFeatureName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.FeatureDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
     */
    featureDefinitions: Array<CfnFeatureGroup.FeatureDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::FeatureGroup.FeatureGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
     */
    featureGroupName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.RecordIdentifierFeatureName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
     */
    recordIdentifierFeatureName: string;
    /**
     * `AWS::SageMaker::FeatureGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::FeatureGroup.OfflineStoreConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
     */
    offlineStoreConfig: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::FeatureGroup.OnlineStoreConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
     */
    onlineStoreConfig: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::FeatureGroup.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::SageMaker::FeatureGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::FeatureGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFeatureGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::FeatureGroup`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::FeatureGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
 */
export declare namespace CfnFeatureGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html
     */
    interface FeatureDefinitionProperty {
        /**
         * `CfnFeatureGroup.FeatureDefinitionProperty.FeatureName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename
         */
        readonly featureName: string;
        /**
         * `CfnFeatureGroup.FeatureDefinitionProperty.FeatureType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype
         */
        readonly featureType: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Image`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
 */
export interface CfnImageProps {
    /**
     * `AWS::SageMaker::Image.ImageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
     */
    readonly imageName: string;
    /**
     * `AWS::SageMaker::Image.ImageRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
     */
    readonly imageRoleArn: string;
    /**
     * `AWS::SageMaker::Image.ImageDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
     */
    readonly imageDescription?: string;
    /**
     * `AWS::SageMaker::Image.ImageDisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
     */
    readonly imageDisplayName?: string;
    /**
     * `AWS::SageMaker::Image.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Image`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Image
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
 */
export declare class CfnImage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Image";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnImage;
    /**
     * @external
     * @cloudformationAttribute ImageArn
     */
    readonly attrImageArn: string;
    /**
     * `AWS::SageMaker::Image.ImageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
     */
    imageName: string;
    /**
     * `AWS::SageMaker::Image.ImageRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
     */
    imageRoleArn: string;
    /**
     * `AWS::SageMaker::Image.ImageDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
     */
    imageDescription: string | undefined;
    /**
     * `AWS::SageMaker::Image.ImageDisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
     */
    imageDisplayName: string | undefined;
    /**
     * `AWS::SageMaker::Image.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Image`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::ImageVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
 */
export interface CfnImageVersionProps {
    /**
     * `AWS::SageMaker::ImageVersion.BaseImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
     */
    readonly baseImage: string;
    /**
     * `AWS::SageMaker::ImageVersion.ImageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
     */
    readonly imageName: string;
}
/**
 * A CloudFormation `AWS::SageMaker::ImageVersion`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ImageVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
 */
export declare class CfnImageVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ImageVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnImageVersion;
    /**
     * @external
     * @cloudformationAttribute ContainerImage
     */
    readonly attrContainerImage: string;
    /**
     * @external
     * @cloudformationAttribute ImageArn
     */
    readonly attrImageArn: string;
    /**
     * @external
     * @cloudformationAttribute ImageVersionArn
     */
    readonly attrImageVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: number;
    /**
     * `AWS::SageMaker::ImageVersion.BaseImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
     */
    baseImage: string;
    /**
     * `AWS::SageMaker::ImageVersion.ImageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
     */
    imageName: string;
    /**
     * Create a new `AWS::SageMaker::ImageVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::Model`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export interface CfnModelProps {
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    readonly containers?: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     */
    readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.InferenceExecutionConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-inferenceexecutionconfig
     */
    readonly inferenceExecutionConfig?: CfnModel.InferenceExecutionConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    readonly modelName?: string;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    readonly primaryContainer?: CfnModel.ContainerDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    readonly vpcConfig?: CfnModel.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModel;
    /**
     * @external
     * @cloudformationAttribute ModelName
     */
    readonly attrModelName: string;
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    containers: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     */
    enableNetworkIsolation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.InferenceExecutionConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-inferenceexecutionconfig
     */
    inferenceExecutionConfig: CfnModel.InferenceExecutionConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    modelName: string | undefined;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    primaryContainer: CfnModel.ContainerDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    vpcConfig: CfnModel.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare namespace CfnModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        readonly containerHostname?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        readonly environment?: any | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        readonly image?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ImageConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-imageconfig
         */
        readonly imageConfig?: CfnModel.ImageConfigProperty | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
         */
        readonly mode?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        readonly modelDataUrl?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelPackageName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
         */
        readonly modelPackageName?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.MultiModelConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-multimodelconfig
         */
        readonly multiModelConfig?: CfnModel.MultiModelConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare namespace CfnModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html
     */
    interface ImageConfigProperty {
        /**
         * `CfnModel.ImageConfigProperty.RepositoryAccessMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryaccessmode
         */
        readonly repositoryAccessMode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare namespace CfnModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html
     */
    interface InferenceExecutionConfigProperty {
        /**
         * `CfnModel.InferenceExecutionConfigProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html#cfn-sagemaker-model-inferenceexecutionconfig-mode
         */
        readonly mode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare namespace CfnModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html
     */
    interface MultiModelConfigProperty {
        /**
         * `CfnModel.MultiModelConfigProperty.ModelCacheSetting`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html#cfn-sagemaker-model-containerdefinition-multimodelconfig-modelcachesetting
         */
        readonly modelCacheSetting?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare namespace CfnModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModel.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export interface CfnModelBiasJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
     */
    readonly jobResources: CfnModelBiasJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
     */
    readonly modelBiasAppSpecification: CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
     */
    readonly modelBiasJobInput: CfnModelBiasJobDefinition.ModelBiasJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
     */
    readonly modelBiasJobOutputConfig: CfnModelBiasJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
     */
    readonly modelBiasBaselineConfig?: CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
     */
    readonly networkConfig?: CfnModelBiasJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
     */
    readonly stoppingCondition?: CfnModelBiasJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare class CfnModelBiasJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelBiasJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelBiasJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
     */
    jobResources: CfnModelBiasJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
     */
    modelBiasAppSpecification: CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
     */
    modelBiasJobInput: CfnModelBiasJobDefinition.ModelBiasJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
     */
    modelBiasJobOutputConfig: CfnModelBiasJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
     */
    modelBiasBaselineConfig: CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
     */
    networkConfig: CfnModelBiasJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
     */
    stoppingCondition: CfnModelBiasJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelBiasJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelBiasJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelBiasJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html#cfn-sagemaker-modelbiasjobdefinition-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.EndTimeOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endtimeoffset
         */
        readonly endTimeOffset?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.FeaturesAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-featuresattribute
         */
        readonly featuresAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-inferenceattribute
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilityattribute
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.ProbabilityThresholdAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilitythresholdattribute
         */
        readonly probabilityThresholdAttribute?: number;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.StartTimeOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-starttimeoffset
         */
        readonly startTimeOffset?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-environment.html
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html
     */
    interface ModelBiasAppSpecificationProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.ConfigUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-configuri
         */
        readonly configUri: string;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-environment
         */
        readonly environment?: CfnModelBiasJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-imageuri
         */
        readonly imageUri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html
     */
    interface ModelBiasBaselineConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty.BaseliningJobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-baseliningjobname
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty.ConstraintsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnModelBiasJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html
     */
    interface ModelBiasJobInputProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasJobInputProperty.EndpointInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-endpointinput
         */
        readonly endpointInput: CfnModelBiasJobDefinition.EndpointInputProperty | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasJobInputProperty.GroundTruthS3Input`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-groundtruths3input
         */
        readonly groundTruthS3Input: CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html
     */
    interface MonitoringGroundTruthS3InputProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutput-s3output
         */
        readonly s3Output: CfnModelBiasJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnModelBiasJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html#cfn-sagemaker-modelbiasjobdefinition-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnModelBiasJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnModelBiasJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelBiasJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelBiasJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export interface CfnModelExplainabilityJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
     */
    readonly jobResources: CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
     */
    readonly modelExplainabilityAppSpecification: CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
     */
    readonly modelExplainabilityJobInput: CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
     */
    readonly modelExplainabilityJobOutputConfig: CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
     */
    readonly modelExplainabilityBaselineConfig?: CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
     */
    readonly networkConfig?: CfnModelExplainabilityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
     */
    readonly stoppingCondition?: CfnModelExplainabilityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare class CfnModelExplainabilityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelExplainabilityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelExplainabilityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
     */
    jobResources: CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
     */
    modelExplainabilityAppSpecification: CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
     */
    modelExplainabilityJobInput: CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
     */
    modelExplainabilityJobOutputConfig: CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
     */
    modelExplainabilityBaselineConfig: CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
     */
    networkConfig: CfnModelExplainabilityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
     */
    stoppingCondition: CfnModelExplainabilityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelExplainabilityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelExplainabilityJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html#cfn-sagemaker-modelexplainabilityjobdefinition-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.FeaturesAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-featuresattribute
         */
        readonly featuresAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-inferenceattribute
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-probabilityattribute
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-environment.html
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html
     */
    interface ModelExplainabilityAppSpecificationProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.ConfigUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-configuri
         */
        readonly configUri: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-environment
         */
        readonly environment?: CfnModelExplainabilityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-imageuri
         */
        readonly imageUri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html
     */
    interface ModelExplainabilityBaselineConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty.BaseliningJobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-baseliningjobname
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty.ConstraintsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html
     */
    interface ModelExplainabilityJobInputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.EndpointInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput-endpointinput
         */
        readonly endpointInput: CfnModelExplainabilityJobDefinition.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutput-s3output
         */
        readonly s3Output: CfnModelExplainabilityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnModelExplainabilityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnModelExplainabilityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnModelExplainabilityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelExplainabilityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelPackageGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html
 */
export interface CfnModelPackageGroupProps {
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupname
     */
    readonly modelPackageGroupName: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupdescription
     */
    readonly modelPackageGroupDescription?: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegrouppolicy
     */
    readonly modelPackageGroupPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelPackageGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelPackageGroup`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelPackageGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html
 */
export declare class CfnModelPackageGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelPackageGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelPackageGroup;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute ModelPackageGroupArn
     */
    readonly attrModelPackageGroupArn: string;
    /**
     * @external
     * @cloudformationAttribute ModelPackageGroupStatus
     */
    readonly attrModelPackageGroupStatus: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupname
     */
    modelPackageGroupName: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupdescription
     */
    modelPackageGroupDescription: string | undefined;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegrouppolicy
     */
    modelPackageGroupPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelPackageGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelPackageGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelPackageGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export interface CfnModelQualityJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources
     */
    readonly jobResources: CfnModelQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification
     */
    readonly modelQualityAppSpecification: CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput
     */
    readonly modelQualityJobInput: CfnModelQualityJobDefinition.ModelQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig
     */
    readonly modelQualityJobOutputConfig: CfnModelQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig
     */
    readonly modelQualityBaselineConfig?: CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig
     */
    readonly networkConfig?: CfnModelQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition
     */
    readonly stoppingCondition?: CfnModelQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare class CfnModelQualityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelQualityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelQualityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobResources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources
     */
    jobResources: CfnModelQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification
     */
    modelQualityAppSpecification: CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput
     */
    modelQualityJobInput: CfnModelQualityJobDefinition.ModelQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobOutputConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig
     */
    modelQualityJobOutputConfig: CfnModelQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobDefinitionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig
     */
    modelQualityBaselineConfig: CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig
     */
    networkConfig: CfnModelQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition
     */
    stoppingCondition: CfnModelQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelQualityJobDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelQualityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html#cfn-sagemaker-modelqualityjobdefinition-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.EndTimeOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endtimeoffset
         */
        readonly endTimeOffset?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-inferenceattribute
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilityattribute
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.ProbabilityThresholdAttribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilitythresholdattribute
         */
        readonly probabilityThresholdAttribute?: number;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.StartTimeOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-starttimeoffset
         */
        readonly startTimeOffset?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-environment.html
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html
     */
    interface ModelQualityAppSpecificationProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ContainerArguments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerarguments
         */
        readonly containerArguments?: string[];
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerentrypoint
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-environment
         */
        readonly environment?: CfnModelQualityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-imageuri
         */
        readonly imageUri: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-postanalyticsprocessorsourceuri
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ProblemType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-problemtype
         */
        readonly problemType: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-recordpreprocessorsourceuri
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html
     */
    interface ModelQualityBaselineConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty.BaseliningJobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-baseliningjobname
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty.ConstraintsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnModelQualityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html
     */
    interface ModelQualityJobInputProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityJobInputProperty.EndpointInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-endpointinput
         */
        readonly endpointInput: CfnModelQualityJobDefinition.EndpointInputProperty | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityJobInputProperty.GroundTruthS3Input`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-groundtruths3input
         */
        readonly groundTruthS3Input: CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html
     */
    interface MonitoringGroundTruthS3InputProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutput-s3output
         */
        readonly s3Output: CfnModelQualityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnModelQualityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html#cfn-sagemaker-modelqualityjobdefinition-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnModelQualityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnModelQualityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelQualityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelQualityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export interface CfnMonitoringScheduleProps {
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    readonly monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    readonly monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    readonly failureReason?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    readonly lastMonitoringExecutionSummary?: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    readonly monitoringScheduleStatus?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare class CfnMonitoringSchedule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::MonitoringSchedule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMonitoringSchedule;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute LastModifiedTime
     */
    readonly attrLastModifiedTime: string;
    /**
     * @external
     * @cloudformationAttribute MonitoringScheduleArn
     */
    readonly attrMonitoringScheduleArn: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    failureReason: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    lastMonitoringExecutionSummary: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    monitoringScheduleStatus: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMonitoringScheduleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html
     */
    interface BaselineConfigProperty {
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnMonitoringSchedule.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource
         */
        readonly statisticsResource?: CfnMonitoringSchedule.StatisticsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-environment.html
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html
     */
    interface MonitoringAppSpecificationProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments
         */
        readonly containerArguments?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri
         */
        readonly imageUri: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html
     */
    interface MonitoringExecutionSummaryProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime
         */
        readonly creationTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname
         */
        readonly endpointName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason
         */
        readonly failureReason?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime
         */
        readonly lastModifiedTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus
         */
        readonly monitoringExecutionStatus: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename
         */
        readonly monitoringScheduleName: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn
         */
        readonly processingJobArn?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime
         */
        readonly scheduledTime: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html
     */
    interface MonitoringInputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput
         */
        readonly endpointInput: CfnMonitoringSchedule.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html
     */
    interface MonitoringJobDefinitionProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig
         */
        readonly baselineConfig?: CfnMonitoringSchedule.BaselineConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment
         */
        readonly environment?: CfnMonitoringSchedule.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification
         */
        readonly monitoringAppSpecification: CfnMonitoringSchedule.MonitoringAppSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs
         */
        readonly monitoringInputs: Array<CfnMonitoringSchedule.MonitoringInputProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig
         */
        readonly monitoringOutputConfig: CfnMonitoringSchedule.MonitoringOutputConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources
         */
        readonly monitoringResources: CfnMonitoringSchedule.MonitoringResourcesProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig
         */
        readonly networkConfig?: CfnMonitoringSchedule.NetworkConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition
         */
        readonly stoppingCondition?: CfnMonitoringSchedule.StoppingConditionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output
         */
        readonly s3Output: CfnMonitoringSchedule.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnMonitoringSchedule.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnMonitoringSchedule.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html
     */
    interface MonitoringScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition
         */
        readonly monitoringJobDefinition?: CfnMonitoringSchedule.MonitoringJobDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinitionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinitionname
         */
        readonly monitoringJobDefinitionName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringtype
         */
        readonly monitoringType?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig
         */
        readonly scheduleConfig?: CfnMonitoringSchedule.ScheduleConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnMonitoringSchedule.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.LocalPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html
     */
    interface ScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression
         */
        readonly scheduleExpression: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.Subnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export interface CfnNotebookInstanceProps {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    readonly acceleratorTypes?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    readonly additionalCodeRepositories?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    readonly defaultCodeRepository?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    readonly directInternetAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    readonly lifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    readonly notebookInstanceName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    readonly rootAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    readonly volumeSizeInGb?: number;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export declare class CfnNotebookInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstance;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceName
     */
    readonly attrNotebookInstanceName: string;
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    acceleratorTypes: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    additionalCodeRepositories: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    defaultCodeRepository: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    directInternetAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    lifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    notebookInstanceName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    rootAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    volumeSizeInGb: number | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotebookInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export interface CfnNotebookInstanceLifecycleConfigProps {
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    readonly notebookInstanceLifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    readonly onCreate?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    readonly onStart?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export declare class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstanceLifecycleConfig;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceLifecycleConfigName
     */
    readonly attrNotebookInstanceLifecycleConfigName: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    notebookInstanceLifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    onCreate: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    onStart: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnNotebookInstanceLifecycleConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export declare namespace CfnNotebookInstanceLifecycleConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html
     */
    interface NotebookInstanceLifecycleHookProperty {
        /**
         * `CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty.Content`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook-content
         */
        readonly content?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Pipeline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html
 */
export interface CfnPipelineProps {
    /**
     * `AWS::SageMaker::Pipeline.PipelineDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition
     */
    readonly pipelineDefinition: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Pipeline.PipelineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename
     */
    readonly pipelineName: string;
    /**
     * `AWS::SageMaker::Pipeline.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription
     */
    readonly pipelineDescription?: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname
     */
    readonly pipelineDisplayName?: string;
    /**
     * `AWS::SageMaker::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition
     */
    pipelineDefinition: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Pipeline.PipelineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename
     */
    pipelineName: string;
    /**
     * `AWS::SageMaker::Pipeline.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription
     */
    pipelineDescription: string | undefined;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname
     */
    pipelineDisplayName: string | undefined;
    /**
     * `AWS::SageMaker::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Pipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPipelineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::Project`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html
 */
export interface CfnProjectProps {
    /**
     * `AWS::SageMaker::Project.ProjectName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectname
     */
    readonly projectName: string;
    /**
     * `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-servicecatalogprovisioningdetails
     */
    readonly serviceCatalogProvisioningDetails: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Project.ProjectDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectdescription
     */
    readonly projectDescription?: string;
    /**
     * `AWS::SageMaker::Project.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Project`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Project
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProject;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute ProjectArn
     */
    readonly attrProjectArn: string;
    /**
     * @external
     * @cloudformationAttribute ProjectId
     */
    readonly attrProjectId: string;
    /**
     * @external
     * @cloudformationAttribute ProjectStatus
     */
    readonly attrProjectStatus: string;
    /**
     * `AWS::SageMaker::Project.ProjectName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectname
     */
    projectName: string;
    /**
     * `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-servicecatalogprovisioningdetails
     */
    serviceCatalogProvisioningDetails: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Project.ProjectDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectdescription
     */
    projectDescription: string | undefined;
    /**
     * `AWS::SageMaker::Project.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export interface CfnUserProfileProps {
    /**
     * `AWS::SageMaker::UserProfile.DomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid
     */
    readonly domainId: string;
    /**
     * `AWS::SageMaker::UserProfile.UserProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename
     */
    readonly userProfileName: string;
    /**
     * `AWS::SageMaker::UserProfile.SingleSignOnUserIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier
     */
    readonly singleSignOnUserIdentifier?: string;
    /**
     * `AWS::SageMaker::UserProfile.SingleSignOnUserValue`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue
     */
    readonly singleSignOnUserValue?: string;
    /**
     * `AWS::SageMaker::UserProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::UserProfile.UserSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings
     */
    readonly userSettings?: CfnUserProfile.UserSettingsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare class CfnUserProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::UserProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnUserProfile;
    /**
     * @external
     * @cloudformationAttribute UserProfileArn
     */
    readonly attrUserProfileArn: string;
    /**
     * `AWS::SageMaker::UserProfile.DomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid
     */
    domainId: string;
    /**
     * `AWS::SageMaker::UserProfile.UserProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename
     */
    userProfileName: string;
    /**
     * `AWS::SageMaker::UserProfile.SingleSignOnUserIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier
     */
    singleSignOnUserIdentifier: string | undefined;
    /**
     * `AWS::SageMaker::UserProfile.SingleSignOnUserValue`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue
     */
    singleSignOnUserValue: string | undefined;
    /**
     * `AWS::SageMaker::UserProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::UserProfile.UserSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings
     */
    userSettings: CfnUserProfile.UserSettingsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::UserProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html
     */
    interface CustomImageProperty {
        /**
         * `CfnUserProfile.CustomImageProperty.AppImageConfigName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-appimageconfigname
         */
        readonly appImageConfigName: string;
        /**
         * `CfnUserProfile.CustomImageProperty.ImageName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imagename
         */
        readonly imageName: string;
        /**
         * `CfnUserProfile.CustomImageProperty.ImageVersionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-customimage.html#cfn-sagemaker-userprofile-customimage-imageversionnumber
         */
        readonly imageVersionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html
     */
    interface JupyterServerAppSettingsProperty {
        /**
         * `CfnUserProfile.JupyterServerAppSettingsProperty.DefaultResourceSpec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-jupyterserverappsettings.html#cfn-sagemaker-userprofile-jupyterserverappsettings-defaultresourcespec
         */
        readonly defaultResourceSpec?: CfnUserProfile.ResourceSpecProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html
     */
    interface KernelGatewayAppSettingsProperty {
        /**
         * `CfnUserProfile.KernelGatewayAppSettingsProperty.CustomImages`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-customimages
         */
        readonly customImages?: Array<CfnUserProfile.CustomImageProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnUserProfile.KernelGatewayAppSettingsProperty.DefaultResourceSpec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-kernelgatewayappsettings.html#cfn-sagemaker-userprofile-kernelgatewayappsettings-defaultresourcespec
         */
        readonly defaultResourceSpec?: CfnUserProfile.ResourceSpecProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html
     */
    interface ResourceSpecProperty {
        /**
         * `CfnUserProfile.ResourceSpecProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnUserProfile.ResourceSpecProperty.SageMakerImageArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimagearn
         */
        readonly sageMakerImageArn?: string;
        /**
         * `CfnUserProfile.ResourceSpecProperty.SageMakerImageVersionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-resourcespec.html#cfn-sagemaker-userprofile-resourcespec-sagemakerimageversionarn
         */
        readonly sageMakerImageVersionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html
     */
    interface SharingSettingsProperty {
        /**
         * `CfnUserProfile.SharingSettingsProperty.NotebookOutputOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-notebookoutputoption
         */
        readonly notebookOutputOption?: string;
        /**
         * `CfnUserProfile.SharingSettingsProperty.S3KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3kmskeyid
         */
        readonly s3KmsKeyId?: string;
        /**
         * `CfnUserProfile.SharingSettingsProperty.S3OutputPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-sharingsettings.html#cfn-sagemaker-userprofile-sharingsettings-s3outputpath
         */
        readonly s3OutputPath?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
export declare namespace CfnUserProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html
     */
    interface UserSettingsProperty {
        /**
         * `CfnUserProfile.UserSettingsProperty.ExecutionRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-executionrole
         */
        readonly executionRole?: string;
        /**
         * `CfnUserProfile.UserSettingsProperty.JupyterServerAppSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-jupyterserverappsettings
         */
        readonly jupyterServerAppSettings?: CfnUserProfile.JupyterServerAppSettingsProperty | cdk.IResolvable;
        /**
         * `CfnUserProfile.UserSettingsProperty.KernelGatewayAppSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-kernelgatewayappsettings
         */
        readonly kernelGatewayAppSettings?: CfnUserProfile.KernelGatewayAppSettingsProperty | cdk.IResolvable;
        /**
         * `CfnUserProfile.UserSettingsProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnUserProfile.UserSettingsProperty.SharingSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-userprofile-usersettings.html#cfn-sagemaker-userprofile-usersettings-sharingsettings
         */
        readonly sharingSettings?: CfnUserProfile.SharingSettingsProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Workteam`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export interface CfnWorkteamProps {
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    readonly memberDefinitions?: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    readonly notificationConfiguration?: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    readonly workteamName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare class CfnWorkteam extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkteam;
    /**
     * @external
     * @cloudformationAttribute WorkteamName
     */
    readonly attrWorkteamName: string;
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    memberDefinitions: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    notificationConfiguration: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    workteamName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkteamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare namespace CfnWorkteam {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     */
    interface CognitoMemberDefinitionProperty {
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         */
        readonly cognitoClientId: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         */
        readonly cognitoUserGroup: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         */
        readonly cognitoUserPool: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare namespace CfnWorkteam {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     */
    interface MemberDefinitionProperty {
        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         */
        readonly cognitoMemberDefinition: CfnWorkteam.CognitoMemberDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare namespace CfnWorkteam {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         */
        readonly notificationTopicArn: string;
    }
}
