import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::S3::AccessPoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 */
export interface CfnAccessPointProps {
    /**
     * `AWS::S3::AccessPoint.Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-bucket
     */
    readonly bucket: string;
    /**
     * `AWS::S3::AccessPoint.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-name
     */
    readonly name?: string;
    /**
     * `AWS::S3::AccessPoint.Policy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policy
     */
    readonly policy?: any | cdk.IResolvable;
    /**
     * `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-publicaccessblockconfiguration
     */
    readonly publicAccessBlockConfiguration?: CfnAccessPoint.PublicAccessBlockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::AccessPoint.VpcConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-vpcconfiguration
     */
    readonly vpcConfiguration?: CfnAccessPoint.VpcConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 */
export declare class CfnAccessPoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::AccessPoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccessPoint;
    /**
     * @external
     * @cloudformationAttribute NetworkOrigin
     */
    readonly attrNetworkOrigin: string;
    /**
     * `AWS::S3::AccessPoint.Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-bucket
     */
    bucket: string;
    /**
     * `AWS::S3::AccessPoint.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-name
     */
    name: string | undefined;
    /**
     * `AWS::S3::AccessPoint.Policy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policy
     */
    policy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-publicaccessblockconfiguration
     */
    publicAccessBlockConfiguration: CfnAccessPoint.PublicAccessBlockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::AccessPoint.VpcConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-vpcconfiguration
     */
    vpcConfiguration: CfnAccessPoint.VpcConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::S3::AccessPoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessPointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 */
export declare namespace CfnAccessPoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html
     */
    interface PublicAccessBlockConfigurationProperty {
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-blockpublicacls
         */
        readonly blockPublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-blockpublicpolicy
         */
        readonly blockPublicPolicy?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-ignorepublicacls
         */
        readonly ignorePublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-restrictpublicbuckets
         */
        readonly restrictPublicBuckets?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 */
export declare namespace CfnAccessPoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-vpcconfiguration.html
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnAccessPoint.VpcConfigurationProperty.VpcId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-vpcconfiguration.html#cfn-s3-accesspoint-vpcconfiguration-vpcid
         */
        readonly vpcId?: string;
    }
}
/**
 * Properties for defining a `AWS::S3::Bucket`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export interface CfnBucketProps {
    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    readonly accelerateConfiguration?: CfnBucket.AccelerateConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.AccessControl`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    readonly accessControl?: string;
    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    readonly analyticsConfigurations?: Array<CfnBucket.AnalyticsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    readonly bucketEncryption?: CfnBucket.BucketEncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    readonly bucketName?: string;
    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    readonly corsConfiguration?: CfnBucket.CorsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.IntelligentTieringConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations
     */
    readonly intelligentTieringConfigurations?: Array<CfnBucket.IntelligentTieringConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    readonly inventoryConfigurations?: Array<CfnBucket.InventoryConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    readonly lifecycleConfiguration?: CfnBucket.LifecycleConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    readonly loggingConfiguration?: CfnBucket.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    readonly metricsConfigurations?: Array<CfnBucket.MetricsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    readonly notificationConfiguration?: CfnBucket.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    readonly objectLockConfiguration?: CfnBucket.ObjectLockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    readonly objectLockEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.OwnershipControls`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols
     */
    readonly ownershipControls?: CfnBucket.OwnershipControlsProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    readonly publicAccessBlockConfiguration?: CfnBucket.PublicAccessBlockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    readonly replicationConfiguration?: CfnBucket.ReplicationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    readonly versioningConfiguration?: CfnBucket.VersioningConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    readonly websiteConfiguration?: CfnBucket.WebsiteConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare class CfnBucket extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::Bucket";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBucket;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DualStackDomainName
     */
    readonly attrDualStackDomainName: string;
    /**
     * @external
     * @cloudformationAttribute RegionalDomainName
     */
    readonly attrRegionalDomainName: string;
    /**
     * @external
     * @cloudformationAttribute WebsiteURL
     */
    readonly attrWebsiteUrl: string;
    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    accelerateConfiguration: CfnBucket.AccelerateConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.AccessControl`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    accessControl: string | undefined;
    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    analyticsConfigurations: Array<CfnBucket.AnalyticsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    bucketEncryption: CfnBucket.BucketEncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    bucketName: string | undefined;
    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    corsConfiguration: CfnBucket.CorsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.IntelligentTieringConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations
     */
    intelligentTieringConfigurations: Array<CfnBucket.IntelligentTieringConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    inventoryConfigurations: Array<CfnBucket.InventoryConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    lifecycleConfiguration: CfnBucket.LifecycleConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    loggingConfiguration: CfnBucket.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    metricsConfigurations: Array<CfnBucket.MetricsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    notificationConfiguration: CfnBucket.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     */
    objectLockConfiguration: CfnBucket.ObjectLockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     */
    objectLockEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.OwnershipControls`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols
     */
    ownershipControls: CfnBucket.OwnershipControlsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    publicAccessBlockConfiguration: CfnBucket.PublicAccessBlockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    replicationConfiguration: CfnBucket.ReplicationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    versioningConfiguration: CfnBucket.VersioningConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    websiteConfiguration: CfnBucket.WebsiteConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::S3::Bucket`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnBucketProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    interface AbortIncompleteMultipartUploadProperty {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        readonly daysAfterInitiation: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    interface AccelerateConfigurationProperty {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        readonly accelerationStatus: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    interface AccessControlTranslationProperty {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        readonly owner: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    interface AnalyticsConfigurationProperty {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        readonly storageClassAnalysis: CfnBucket.StorageClassAnalysisProperty | cdk.IResolvable;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    interface BucketEncryptionProperty {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        readonly serverSideEncryptionConfiguration: Array<CfnBucket.ServerSideEncryptionRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    interface CorsConfigurationProperty {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        readonly corsRules: Array<CfnBucket.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    interface CorsRuleProperty {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        readonly allowedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        readonly allowedMethods: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        readonly allowedOrigins: string[];
        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        readonly exposedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        readonly maxAge?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    interface DataExportProperty {
        /**
         * `CfnBucket.DataExportProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        readonly outputSchemaVersion: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html
     */
    interface DefaultRetentionProperty {
        /**
         * `CfnBucket.DefaultRetentionProperty.Days`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
         */
        readonly days?: number;
        /**
         * `CfnBucket.DefaultRetentionProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
         */
        readonly mode?: string;
        /**
         * `CfnBucket.DefaultRetentionProperty.Years`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
         */
        readonly years?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html
     */
    interface DeleteMarkerReplicationProperty {
        /**
         * `CfnBucket.DeleteMarkerReplicationProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html#cfn-s3-bucket-deletemarkerreplication-status
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    interface DestinationProperty {
        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        readonly bucketAccountId?: string;
        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnBucket.DestinationProperty.Format`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        readonly format: string;
        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        readonly replicaKmsKeyId: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    interface FilterRuleProperty {
        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        readonly name: string;
        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html
     */
    interface IntelligentTieringConfigurationProperty {
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-status
         */
        readonly status: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Tierings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-tierings
         */
        readonly tierings: Array<CfnBucket.TieringProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    interface InventoryConfigurationProperty {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        readonly includedObjectVersions: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        readonly optionalFields?: string[];
        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        readonly scheduleFrequency: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    interface LambdaConfigurationProperty {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        readonly function: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    interface LifecycleConfigurationProperty {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        readonly rules: Array<CfnBucket.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        readonly destinationBucketName?: string;
        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        readonly logFilePrefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html
     */
    interface MetricsProperty {
        /**
         * `CfnBucket.MetricsProperty.EventThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-eventthreshold
         */
        readonly eventThreshold?: CfnBucket.ReplicationTimeValueProperty | cdk.IResolvable;
        /**
         * `CfnBucket.MetricsProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-status
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    interface MetricsConfigurationProperty {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    interface NoncurrentVersionTransitionProperty {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        readonly transitionInDays: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        readonly lambdaConfigurations?: Array<CfnBucket.LambdaConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        readonly queueConfigurations?: Array<CfnBucket.QueueConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        readonly topicConfigurations?: Array<CfnBucket.TopicConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    interface NotificationFilterProperty {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        readonly s3Key: CfnBucket.S3KeyFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html
     */
    interface ObjectLockConfigurationProperty {
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
         */
        readonly objectLockEnabled?: string;
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
         */
        readonly rule?: CfnBucket.ObjectLockRuleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html
     */
    interface ObjectLockRuleProperty {
        /**
         * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
         */
        readonly defaultRetention?: CfnBucket.DefaultRetentionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html
     */
    interface OwnershipControlsProperty {
        /**
         * `CfnBucket.OwnershipControlsProperty.Rules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html#cfn-s3-bucket-ownershipcontrols-rules
         */
        readonly rules: Array<CfnBucket.OwnershipControlsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrolsrule.html
     */
    interface OwnershipControlsRuleProperty {
        /**
         * `CfnBucket.OwnershipControlsRuleProperty.ObjectOwnership`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrolsrule.html#cfn-s3-bucket-ownershipcontrolsrule-objectownership
         */
        readonly objectOwnership?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    interface PublicAccessBlockConfigurationProperty {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        readonly blockPublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        readonly blockPublicPolicy?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        readonly ignorePublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        readonly restrictPublicBuckets?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    interface QueueConfigurationProperty {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        readonly queue: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    interface RedirectAllRequestsToProperty {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        readonly hostName: string;
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        readonly protocol?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    interface RedirectRuleProperty {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        readonly hostName?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        readonly httpRedirectCode?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        readonly replaceKeyPrefixWith?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        readonly replaceKeyWith?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicamodifications.html
     */
    interface ReplicaModificationsProperty {
        /**
         * `CfnBucket.ReplicaModificationsProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicamodifications.html#cfn-s3-bucket-replicamodifications-status
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    interface ReplicationConfigurationProperty {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        readonly role: string;
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        readonly rules: Array<CfnBucket.ReplicationRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    interface ReplicationDestinationProperty {
        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        readonly accessControlTranslation?: CfnBucket.AccessControlTranslationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        readonly account?: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        readonly bucket: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnBucket.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Metrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-metrics
         */
        readonly metrics?: CfnBucket.MetricsProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.ReplicationTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-replicationtime
         */
        readonly replicationTime?: CfnBucket.ReplicationTimeProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        readonly storageClass?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    interface ReplicationRuleProperty {
        /**
         * `CfnBucket.ReplicationRuleProperty.DeleteMarkerReplication`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-deletemarkerreplication
         */
        readonly deleteMarkerReplication?: CfnBucket.DeleteMarkerReplicationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        readonly destination: CfnBucket.ReplicationDestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-filter
         */
        readonly filter?: CfnBucket.ReplicationRuleFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-priority
         */
        readonly priority?: number;
        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        readonly sourceSelectionCriteria?: CfnBucket.SourceSelectionCriteriaProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html
     */
    interface ReplicationRuleAndOperatorProperty {
        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html
     */
    interface ReplicationRuleFilterProperty {
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.And`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-and
         */
        readonly and?: CfnBucket.ReplicationRuleAndOperatorProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.TagFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-tagfilter
         */
        readonly tagFilter?: CfnBucket.TagFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html
     */
    interface ReplicationTimeProperty {
        /**
         * `CfnBucket.ReplicationTimeProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-status
         */
        readonly status: string;
        /**
         * `CfnBucket.ReplicationTimeProperty.Time`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-time
         */
        readonly time: CfnBucket.ReplicationTimeValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html
     */
    interface ReplicationTimeValueProperty {
        /**
         * `CfnBucket.ReplicationTimeValueProperty.Minutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html#cfn-s3-bucket-replicationtimevalue-minutes
         */
        readonly minutes: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    interface RoutingRuleProperty {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        readonly redirectRule: CfnBucket.RedirectRuleProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        readonly routingRuleCondition?: CfnBucket.RoutingRuleConditionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    interface RoutingRuleConditionProperty {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        readonly httpErrorCodeReturnedEquals?: string;
        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        readonly keyPrefixEquals?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    interface RuleProperty {
        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        readonly abortIncompleteMultipartUpload?: CfnBucket.AbortIncompleteMultipartUploadProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        readonly expirationDate?: Date | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        readonly expirationInDays?: number;
        /**
         * `CfnBucket.RuleProperty.ExpiredObjectDeleteMarker`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-expiredobjectdeletemarker
         */
        readonly expiredObjectDeleteMarker?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        readonly noncurrentVersionExpirationInDays?: number;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        readonly noncurrentVersionTransition?: CfnBucket.NoncurrentVersionTransitionProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        readonly noncurrentVersionTransitions?: Array<CfnBucket.NoncurrentVersionTransitionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.RuleProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        readonly status: string;
        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Transition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        readonly transition?: CfnBucket.TransitionProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Transitions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        readonly transitions?: Array<CfnBucket.TransitionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    interface S3KeyFilterProperty {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        readonly rules: Array<CfnBucket.FilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    interface ServerSideEncryptionByDefaultProperty {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        readonly sseAlgorithm: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    interface ServerSideEncryptionRuleProperty {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.BucketKeyEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-bucketkeyenabled
         */
        readonly bucketKeyEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        readonly serverSideEncryptionByDefault?: CfnBucket.ServerSideEncryptionByDefaultProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    interface SourceSelectionCriteriaProperty {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.ReplicaModifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-replicamodifications
         */
        readonly replicaModifications?: CfnBucket.ReplicaModificationsProperty | cdk.IResolvable;
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        readonly sseKmsEncryptedObjects?: CfnBucket.SseKmsEncryptedObjectsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    interface SseKmsEncryptedObjectsProperty {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    interface StorageClassAnalysisProperty {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        readonly dataExport?: CfnBucket.DataExportProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    interface TagFilterProperty {
        /**
         * `CfnBucket.TagFilterProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        readonly key: string;
        /**
         * `CfnBucket.TagFilterProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html
     */
    interface TieringProperty {
        /**
         * `CfnBucket.TieringProperty.AccessTier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html#cfn-s3-bucket-tiering-accesstier
         */
        readonly accessTier: string;
        /**
         * `CfnBucket.TieringProperty.Days`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html#cfn-s3-bucket-tiering-days
         */
        readonly days: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    interface TopicConfigurationProperty {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        readonly topic: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    interface TransitionProperty {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        readonly transitionDate?: Date | cdk.IResolvable;
        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        readonly transitionInDays?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    interface VersioningConfigurationProperty {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @external
 * @cloudformationResource AWS::S3::Bucket
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare namespace CfnBucket {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    interface WebsiteConfigurationProperty {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        readonly errorDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        readonly indexDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        readonly redirectAllRequestsTo?: CfnBucket.RedirectAllRequestsToProperty | cdk.IResolvable;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        readonly routingRules?: Array<CfnBucket.RoutingRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::S3::BucketPolicy`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
export interface CfnBucketPolicyProps {
    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    readonly bucket: string;
    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    readonly policyDocument: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::BucketPolicy`.
 *
 * @external
 * @cloudformationResource AWS::S3::BucketPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
export declare class CfnBucketPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::BucketPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBucketPolicy;
    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    bucket: string;
    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * Create a new `AWS::S3::BucketPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBucketPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::S3::StorageLens`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export interface CfnStorageLensProps {
    /**
     * `AWS::S3::StorageLens.StorageLensConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-storagelensconfiguration
     */
    readonly storageLensConfiguration: CfnStorageLens.StorageLensConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::StorageLens.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare class CfnStorageLens extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::StorageLens";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStorageLens;
    /**
     * @external
     * @cloudformationAttribute StorageLensArn
     */
    readonly attrStorageLensArn: string;
    /**
     * `AWS::S3::StorageLens.StorageLensConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-storagelensconfiguration
     */
    storageLensConfiguration: CfnStorageLens.StorageLensConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::StorageLens.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::S3::StorageLens`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStorageLensProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html
     */
    interface AccountLevelProperty {
        /**
         * `CfnStorageLens.AccountLevelProperty.ActivityMetrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html#cfn-s3-storagelens-accountlevel-activitymetrics
         */
        readonly activityMetrics?: CfnStorageLens.ActivityMetricsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.AccountLevelProperty.BucketLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html#cfn-s3-storagelens-accountlevel-bucketlevel
         */
        readonly bucketLevel: CfnStorageLens.BucketLevelProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-activitymetrics.html
     */
    interface ActivityMetricsProperty {
        /**
         * `CfnStorageLens.ActivityMetricsProperty.IsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-activitymetrics.html#cfn-s3-storagelens-activitymetrics-isenabled
         */
        readonly isEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-awsorg.html
     */
    interface AwsOrgProperty {
        /**
         * `CfnStorageLens.AwsOrgProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-awsorg.html#cfn-s3-storagelens-awsorg-arn
         */
        readonly arn: string;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html
     */
    interface BucketLevelProperty {
        /**
         * `CfnStorageLens.BucketLevelProperty.ActivityMetrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html#cfn-s3-storagelens-bucketlevel-activitymetrics
         */
        readonly activityMetrics?: CfnStorageLens.ActivityMetricsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.BucketLevelProperty.PrefixLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html#cfn-s3-storagelens-bucketlevel-prefixlevel
         */
        readonly prefixLevel?: CfnStorageLens.PrefixLevelProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html
     */
    interface BucketsAndRegionsProperty {
        /**
         * `CfnStorageLens.BucketsAndRegionsProperty.Buckets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html#cfn-s3-storagelens-bucketsandregions-buckets
         */
        readonly buckets?: string[];
        /**
         * `CfnStorageLens.BucketsAndRegionsProperty.Regions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html#cfn-s3-storagelens-bucketsandregions-regions
         */
        readonly regions?: string[];
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-dataexport.html
     */
    interface DataExportProperty {
        /**
         * `CfnStorageLens.DataExportProperty.S3BucketDestination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-dataexport.html#cfn-s3-storagelens-dataexport-s3bucketdestination
         */
        readonly s3BucketDestination: CfnStorageLens.S3BucketDestinationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-encryption.html
     */
    interface EncryptionProperty {
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevel.html
     */
    interface PrefixLevelProperty {
        /**
         * `CfnStorageLens.PrefixLevelProperty.StorageMetrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevel.html#cfn-s3-storagelens-prefixlevel-storagemetrics
         */
        readonly storageMetrics: CfnStorageLens.PrefixLevelStorageMetricsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html
     */
    interface PrefixLevelStorageMetricsProperty {
        /**
         * `CfnStorageLens.PrefixLevelStorageMetricsProperty.IsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html#cfn-s3-storagelens-prefixlevelstoragemetrics-isenabled
         */
        readonly isEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStorageLens.PrefixLevelStorageMetricsProperty.SelectionCriteria`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html#cfn-s3-storagelens-prefixlevelstoragemetrics-selectioncriteria
         */
        readonly selectionCriteria?: CfnStorageLens.SelectionCriteriaProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html
     */
    interface S3BucketDestinationProperty {
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.AccountId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-accountid
         */
        readonly accountId: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-arn
         */
        readonly arn: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-encryption
         */
        readonly encryption?: CfnStorageLens.EncryptionProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Format`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-format
         */
        readonly format: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.OutputSchemaVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-outputschemaversion
         */
        readonly outputSchemaVersion: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-prefix
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html
     */
    interface SelectionCriteriaProperty {
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.Delimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-delimiter
         */
        readonly delimiter?: string;
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.MaxDepth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-maxdepth
         */
        readonly maxDepth?: number;
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.MinStorageBytesPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-minstoragebytespercentage
         */
        readonly minStorageBytesPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 */
export declare namespace CfnStorageLens {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html
     */
    interface StorageLensConfigurationProperty {
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.AccountLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-accountlevel
         */
        readonly accountLevel: CfnStorageLens.AccountLevelProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.AwsOrg`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-awsorg
         */
        readonly awsOrg?: CfnStorageLens.AwsOrgProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.DataExport`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-dataexport
         */
        readonly dataExport?: CfnStorageLens.DataExportProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Exclude`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-exclude
         */
        readonly exclude?: CfnStorageLens.BucketsAndRegionsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Include`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-include
         */
        readonly include?: CfnStorageLens.BucketsAndRegionsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.IsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-isenabled
         */
        readonly isEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.StorageLensArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-storagelensarn
         */
        readonly storageLensArn?: string;
    }
}
