import { PolicyDocument } from "../../aws-iam";
import { RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { IBucket } from './bucket';
/**
 * @experimental
 */
export interface BucketPolicyProps {
    /**
     * (experimental) The Amazon S3 bucket that the policy applies to.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) Policy to apply when the policy is removed from this stack.
     *
     * @default - RemovalPolicy.DESTROY.
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 *
 * @experimental
 */
export declare class BucketPolicy extends Resource {
    /**
     * (experimental) A policy document containing permissions to add to the specified bucket.
     *
     * For more information, see Access Policy Language Overview in the Amazon
     * Simple Storage Service Developer Guide.
     *
     * @experimental
     */
    readonly document: PolicyDocument;
    private resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BucketPolicyProps);
    /**
     * (experimental) Sets the removal policy for the BucketPolicy.
     *
     * @param removalPolicy the RemovalPolicy to set.
     * @experimental
     */
    applyRemovalPolicy(removalPolicy: RemovalPolicy): void;
}
