"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
/**
 * (experimental) Use an SQS queue as a bucket notification destination.
 *
 * @experimental
 */
class SqsDestination {
    /**
     * @experimental
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * (experimental) Allows using SQS queues as destinations for bucket notifications.
     *
     * Use `bucket.onEvent(event, queue)` to subscribe.
     *
     * @experimental
     */
    bind(_scope, bucket) {
        this.queue.grantSendMessages(new iam.ServicePrincipal('s3.amazonaws.com', {
            conditions: {
                ArnLike: { 'aws:SourceArn': bucket.bucketArn },
            },
        }));
        // if this queue is encrypted, we need to allow S3 to read messages since that's how
        // it verifies that the notification destination configuration is valid.
        if (this.queue.encryptionMasterKey) {
            this.queue.encryptionMasterKey.addToResourcePolicy(new iam.PolicyStatement({
                principals: [new iam.ServicePrincipal('s3.amazonaws.com')],
                actions: ['kms:GenerateDataKey*', 'kms:Decrypt'],
                resources: ['*'],
            }), /* allowNoOp */ false);
        }
        return {
            arn: this.queue.queueArn,
            type: s3.BucketNotificationDestinationType.QUEUE,
            dependencies: [this.queue],
        };
    }
}
exports.SqsDestination = SqsDestination;
_a = JSII_RTTI_SYMBOL_1;
SqsDestination[_a] = { fqn: "monocdk.aws_s3_notifications.SqsDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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