"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a Lambda function as a bucket notification destination.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * (experimental) Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @experimental
     */
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!core_2.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_s3_notifications.LambdaDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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