import * as cloudfront from "../../aws-cloudfront";
import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { ISource } from './source';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for `BucketDeployment`.
 *
 * @experimental
 */
export interface BucketDeploymentProps {
    /**
     * (experimental) The sources from which to deploy the contents of this bucket.
     *
     * @experimental
     */
    readonly sources: ISource[];
    /**
     * (experimental) The S3 bucket to sync the contents of the zip file to.
     *
     * @experimental
     */
    readonly destinationBucket: s3.IBucket;
    /**
     * (experimental) Key prefix in the destination bucket.
     *
     * @default "/" (unzip to root of the destination bucket)
     * @experimental
     */
    readonly destinationKeyPrefix?: string;
    /**
     * (experimental) If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
     *
     * @default true
     * @see https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html
     * @experimental
     */
    readonly prune?: boolean;
    /**
     * (experimental) If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
     *
     * NOTICE: Configuring this to "false" might have operational implications. Please
     * visit to the package documentation referred below to make sure you fully understand those implications.
     *
     * @default true - when resource is deleted/updated, files are retained
     * @see https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete
     * @experimental
     */
    readonly retainOnDelete?: boolean;
    /**
     * (experimental) The CloudFront distribution using the destination bucket as an origin.
     *
     * Files in the distribution's edge caches will be invalidated after
     * files are uploaded to the destination bucket.
     *
     * @default - No invalidation occurs
     * @experimental
     */
    readonly distribution?: cloudfront.IDistribution;
    /**
     * (experimental) The file paths to invalidate in the CloudFront distribution.
     *
     * @default - All files under the destination bucket key prefix will be invalidated.
     * @experimental
     */
    readonly distributionPaths?: string[];
    /**
     * (experimental) The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
     *
     * If you are deploying large files, you will need to increase this number
     * accordingly.
     *
     * @default 128
     * @experimental
     */
    readonly memoryLimit?: number;
    /**
     * (experimental) Execution role associated with this function.
     *
     * @default - A role is automatically created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) User-defined object metadata to be set on all objects in the deployment.
     *
     * @default - No user metadata is set
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata
     * @experimental
     */
    readonly metadata?: UserDefinedObjectMetadata;
    /**
     * (experimental) System-defined cache-control metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly cacheControl?: CacheControl[];
    /**
     * (experimental) System-defined cache-disposition metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly contentDisposition?: string;
    /**
     * (experimental) System-defined content-encoding metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly contentEncoding?: string;
    /**
     * (experimental) System-defined content-language metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly contentLanguage?: string;
    /**
     * (experimental) System-defined content-type metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly contentType?: string;
    /**
     * (experimental) System-defined expires metadata to be set on all objects in the deployment.
     *
     * @default - The objects in the distribution will not expire.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly expires?: cdk.Expiration;
    /**
     * (experimental) System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
     *
     * @default - Server side encryption is not used.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly serverSideEncryption?: ServerSideEncryption;
    /**
     * (experimental) System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
     *
     * @default - Default storage-class for the bucket is used.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly storageClass?: StorageClass;
    /**
     * (experimental) System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
     *
     * @default - No website redirection.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly websiteRedirectLocation?: string;
    /**
     * (experimental) System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     * @experimental
     */
    readonly serverSideEncryptionAwsKmsKeyId?: string;
    /**
     * (experimental) System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
     *
     * Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
     *
     * @default - Not set.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro
     * @experimental
     */
    readonly serverSideEncryptionCustomerAlgorithm?: string;
    /**
     * (experimental) The VPC network to place the deployment lambda handler in.
     *
     * @default None
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Where in the VPC to place the deployment lambda handler.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - the Vpc default strategy if not specified
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
}
/**
 * (experimental) `BucketDeployment` populates an S3 bucket with the contents of .zip files from other S3 buckets or from local disk.
 *
 * @experimental
 */
export declare class BucketDeployment extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BucketDeploymentProps);
    private renderSingletonUuid;
}
/**
 * (experimental) Used for HTTP cache-control header, which influences downstream caches.
 *
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
 * @experimental
 */
export declare class CacheControl {
    /**
     * The raw cache control setting.
     */
    readonly value: any;
    /**
     * (experimental) Sets 'must-revalidate'.
     *
     * @experimental
     */
    static mustRevalidate(): CacheControl;
    /**
     * (experimental) Sets 'no-cache'.
     *
     * @experimental
     */
    static noCache(): CacheControl;
    /**
     * (experimental) Sets 'no-transform'.
     *
     * @experimental
     */
    static noTransform(): CacheControl;
    /**
     * (experimental) Sets 'public'.
     *
     * @experimental
     */
    static setPublic(): CacheControl;
    /**
     * (experimental) Sets 'private'.
     *
     * @experimental
     */
    static setPrivate(): CacheControl;
    /**
     * (experimental) Sets 'proxy-revalidate'.
     *
     * @experimental
     */
    static proxyRevalidate(): CacheControl;
    /**
     * (experimental) Sets 'max-age=<duration-in-seconds>'.
     *
     * @experimental
     */
    static maxAge(t: cdk.Duration): CacheControl;
    /**
     * (experimental) Sets 's-maxage=<duration-in-seconds>'.
     *
     * @experimental
     */
    static sMaxAge(t: cdk.Duration): CacheControl;
    /**
     * (experimental) Constructs a custom cache control key from the literal value.
     *
     * @experimental
     */
    static fromString(s: string): CacheControl;
    private constructor();
}
/**
 * (experimental) Indicates whether server-side encryption is enabled for the object, and whether that encryption is from the AWS Key Management Service (AWS KMS) or from Amazon S3 managed encryption (SSE-S3).
 *
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
 * @experimental
 */
export declare enum ServerSideEncryption {
    /**
     * (experimental) 'AES256'.
     *
     * @experimental
     */
    AES_256 = "AES256",
    /**
     * (experimental) 'aws:kms'.
     *
     * @experimental
     */
    AWS_KMS = "aws:kms"
}
/**
 * (experimental) Storage class used for storing the object.
 *
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
 * @experimental
 */
export declare enum StorageClass {
    /**
     * (experimental) 'STANDARD'.
     *
     * @experimental
     */
    STANDARD = "STANDARD",
    /**
     * (experimental) 'REDUCED_REDUNDANCY'.
     *
     * @experimental
     */
    REDUCED_REDUNDANCY = "REDUCED_REDUNDANCY",
    /**
     * (experimental) 'STANDARD_IA'.
     *
     * @experimental
     */
    STANDARD_IA = "STANDARD_IA",
    /**
     * (experimental) 'ONEZONE_IA'.
     *
     * @experimental
     */
    ONEZONE_IA = "ONEZONE_IA",
    /**
     * (experimental) 'INTELLIGENT_TIERING'.
     *
     * @experimental
     */
    INTELLIGENT_TIERING = "INTELLIGENT_TIERING",
    /**
     * (experimental) 'GLACIER'.
     *
     * @experimental
     */
    GLACIER = "GLACIER",
    /**
     * (experimental) 'DEEP_ARCHIVE'.
     *
     * @experimental
     */
    DEEP_ARCHIVE = "DEEP_ARCHIVE"
}
/**
 * (deprecated) Used for HTTP expires header, which influences downstream caches.
 *
 * Does NOT influence deletion of the object.
 *
 * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
 * @deprecated use core.Expiration
 */
export declare class Expires {
    /**
     * The raw expiration date expression.
     */
    readonly value: any;
    /**
     * (deprecated) Expire at the specified date.
     *
     * @param d date to expire at.
     * @deprecated
     */
    static atDate(d: Date): Expires;
    /**
     * (deprecated) Expire at the specified timestamp.
     *
     * @param t timestamp in unix milliseconds.
     * @deprecated
     */
    static atTimestamp(t: number): Expires;
    /**
     * (deprecated) Expire once the specified duration has passed since deployment time.
     *
     * @param t the duration to wait before expiring.
     * @deprecated
     */
    static after(t: cdk.Duration): Expires;
    /**
     * (deprecated) Create an expiration date from a raw date string.
     *
     * @deprecated
     */
    static fromString(s: string): Expires;
    private constructor();
}
/**
 * (experimental) Custom user defined metadata.
 *
 * @experimental
 */
export interface UserDefinedObjectMetadata {
    /**
     * Arbitrary metadata key-values
     * The `x-amz-meta-` prefix will automatically be added to keys.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata
     */
    readonly [key: string]: string;
}
