"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSymlinkFollow = void 0;
const assets_1 = require("../../assets"); // Automatically re-written from '@aws-cdk/assets'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case assets_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case assets_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case assets_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case assets_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlDQUEwQyxDQUFDLGtEQUFrRDtBQUM3RixxQ0FBK0MsQ0FBQyxnREFBZ0Q7QUFDaEcsU0FBZ0IsZUFBZSxDQUFDLE1BQW1CO0lBQy9DLElBQUksQ0FBQyxNQUFNLEVBQUU7UUFDVCxPQUFPLFNBQVMsQ0FBQztLQUNwQjtJQUNELFFBQVEsTUFBTSxFQUFFO1FBQ1osS0FBSyxtQkFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsS0FBSyxDQUFDO1FBQ3RELEtBQUssbUJBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLE1BQU0sQ0FBQztRQUN4RCxLQUFLLG1CQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxjQUFjLENBQUM7UUFDeEUsS0FBSyxtQkFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsUUFBUSxDQUFDO1FBQzVEO1lBQ0ksTUFBTSxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUN6RDtBQUNMLENBQUM7QUFaRCwwQ0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZvbGxvd01vZGUgfSBmcm9tIFwiLi4vLi4vYXNzZXRzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hc3NldHMnXG5pbXBvcnQgeyBTeW1saW5rRm9sbG93TW9kZSB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuZXhwb3J0IGZ1bmN0aW9uIHRvU3ltbGlua0ZvbGxvdyhmb2xsb3c/OiBGb2xsb3dNb2RlKTogU3ltbGlua0ZvbGxvd01vZGUgfCB1bmRlZmluZWQge1xuICAgIGlmICghZm9sbG93KSB7XG4gICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfVxuICAgIHN3aXRjaCAoZm9sbG93KSB7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5ORVZFUjogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLk5FVkVSO1xuICAgICAgICBjYXNlIEZvbGxvd01vZGUuQUxXQVlTOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuQUxXQVlTO1xuICAgICAgICBjYXNlIEZvbGxvd01vZGUuQkxPQ0tfRVhURVJOQUw6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5CTE9DS19FWFRFUk5BTDtcbiAgICAgICAgY2FzZSBGb2xsb3dNb2RlLkVYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuRVhURVJOQUw7XG4gICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYHVua25vd24gZm9sbG93IG1vZGU6ICR7Zm9sbG93fWApO1xuICAgIH1cbn1cbiJdfQ==