import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { CopyOptions } from "../../assets";
import { Construct as CoreConstruct } from "../../core";
/**
 * @experimental
 */
export interface AssetOptions extends CopyOptions, cdk.FileCopyOptions, cdk.AssetOptions {
    /**
     * (experimental) A list of principals that should be able to read this asset from S3.
     *
     * You can use `asset.grantRead(principal)` to grant read permissions later.
     *
     * @default - No principals that can read file asset.
     * @experimental
     */
    readonly readers?: iam.IGrantable[];
    /**
     * (deprecated) Custom hash to use when identifying the specific version of the asset.
     *
     * For consistency,
     * this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be
     * the asset hash.
     *
     * NOTE: the source hash is used in order to identify a specific revision of the asset,
     * and used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the source hash,
     * you will need to make sure it is updated every time the source changes, or otherwise
     * it is possible that some deployments will not be invalidated.
     *
     * @default - automatically calculate source hash based on the contents
     * of the source file or directory.
     * @deprecated see `assetHash` and `assetHashType`
     */
    readonly sourceHash?: string;
}
/**
 * @experimental
 */
export interface AssetProps extends AssetOptions {
    /**
     * (experimental) The disk location of the asset.
     *
     * The path should refer to one of the following:
     * - A regular file or a .zip file, in which case the file will be uploaded as-is to S3.
     * - A directory, in which case it will be archived into a .zip file and uploaded to S3.
     *
     * @experimental
     */
    readonly path: string;
}
/**
 * (experimental) An asset represents a local file or directory, which is automatically uploaded to S3 and then can be referenced within a CDK application.
 *
 * @experimental
 */
export declare class Asset extends CoreConstruct implements cdk.IAsset {
    /**
     * (experimental) Attribute that represents the name of the bucket this asset exists in.
     *
     * @experimental
     */
    readonly s3BucketName: string;
    /**
     * (experimental) Attribute which represents the S3 object key of this asset.
     *
     * @experimental
     */
    readonly s3ObjectKey: string;
    /**
     * (deprecated) Attribute which represents the S3 URL of this asset.
     *
     * @deprecated use `httpUrl`
     */
    readonly s3Url: string;
    /**
     * (experimental) Attribute which represents the S3 HTTP URL of this asset.
     *
     * @experimental
     * @example
     *
     * https://s3.us-west-1.amazonaws.com/bucket/key
     */
    readonly httpUrl: string;
    /**
     * (experimental) Attribute which represents the S3 URL of this asset.
     *
     * @experimental
     * @example
     *
     * s3://bucket/key
     */
    readonly s3ObjectUrl: string;
    /**
     * (experimental) The path to the asset, relative to the current Cloud Assembly.
     *
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     *
     * @experimental
     */
    readonly assetPath: string;
    /**
     * (experimental) The S3 bucket in which this asset resides.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) Indicates if this asset is a single file.
     *
     * Allows constructs to ensure that the
     * correct file type was used.
     *
     * @experimental
     */
    readonly isFile: boolean;
    /**
     * (experimental) Indicates if this asset is a zip archive.
     *
     * Allows constructs to ensure that the
     * correct file type was used.
     *
     * @experimental
     */
    readonly isZipArchive: boolean;
    /**
     * (deprecated) A cryptographic hash of the asset.
     *
     * @deprecated see `assetHash`
     */
    readonly sourceHash: string;
    /**
     * (experimental) A hash of this asset, which is available at construction time.
     *
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     *
     * @experimental
     */
    readonly assetHash: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AssetProps);
    /**
     * (experimental) Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     *
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     *
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     *
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface].
     * @param resourceProperty The property name where this asset is referenced (e.g. "Code" for AWS::Lambda::Function).
     * @see https://github.com/aws/aws-cdk/issues/1432
     * @experimental
     */
    addResourceMetadata(resource: cdk.CfnResource, resourceProperty: string): void;
    /**
     * (experimental) Grants read permissions to the principal on the assets bucket.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): void;
}
