import * as iam from "../../aws-iam";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IAliasRecordTarget } from './alias-record-target';
import { IHostedZone } from './hosted-zone-ref';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) A record set.
 *
 * @experimental
 */
export interface IRecordSet extends IResource {
    /**
     * (experimental) The domain name of the record.
     *
     * @experimental
     */
    readonly domainName: string;
}
/**
 * (experimental) The record type.
 *
 * @experimental
 */
export declare enum RecordType {
    /**
     * (experimental) route traffic to a resource, such as a web server, using an IPv4 address in dotted decimal notation.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AFormat
     * @experimental
     */
    A = "A",
    /**
     * (experimental) route traffic to a resource, such as a web server, using an IPv6 address in colon-separated hexadecimal format.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AAAAFormat
     * @experimental
     */
    AAAA = "AAAA",
    /**
     * (experimental) A CAA record specifies which certificate authorities (CAs) are allowed to issue certificates for a domain or subdomain.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CAAFormat
     * @experimental
     */
    CAA = "CAA",
    /**
     * (experimental) A CNAME record maps DNS queries for the name of the current record, such as acme.example.com, to another domain (example.com or example.net) or subdomain (acme.example.com or zenith.example.org).
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CNAMEFormat
     * @experimental
     */
    CNAME = "CNAME",
    /**
     * (experimental) An MX record specifies the names of your mail servers and, if you have two or more mail servers, the priority order.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#MXFormat
     * @experimental
     */
    MX = "MX",
    /**
     * (experimental) A Name Authority Pointer (NAPTR) is a type of record that is used by Dynamic Delegation Discovery System (DDDS) applications to convert one value to another or to replace one value with another.
     *
     * For example, one common use is to convert phone numbers into SIP URIs.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NAPTRFormat
     * @experimental
     */
    NAPTR = "NAPTR",
    /**
     * (experimental) An NS record identifies the name servers for the hosted zone.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NSFormat
     * @experimental
     */
    NS = "NS",
    /**
     * (experimental) A PTR record maps an IP address to the corresponding domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#PTRFormat
     * @experimental
     */
    PTR = "PTR",
    /**
     * (experimental) A start of authority (SOA) record provides information about a domain and the corresponding Amazon Route 53 hosted zone.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SOAFormat
     * @experimental
     */
    SOA = "SOA",
    /**
     * (experimental) SPF records were formerly used to verify the identity of the sender of email messages.
     *
     * Instead of an SPF record, we recommend that you create a TXT record that contains the applicable value.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SPFFormat
     * @experimental
     */
    SPF = "SPF",
    /**
     * (experimental) An SRV record Value element consists of four space-separated values.
     *
     * The first three values are
     * decimal numbers representing priority, weight, and port. The fourth value is a domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SRVFormat
     * @experimental
     */
    SRV = "SRV",
    /**
     * (experimental) A TXT record contains one or more strings that are enclosed in double quotation marks (").
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#TXTFormat
     * @experimental
     */
    TXT = "TXT"
}
/**
 * (experimental) Options for a RecordSet.
 *
 * @experimental
 */
export interface RecordSetOptions {
    /**
     * (experimental) The hosted zone in which to define the new record.
     *
     * @experimental
     */
    readonly zone: IHostedZone;
    /**
     * (experimental) The domain name for this record.
     *
     * @default zone root
     * @experimental
     */
    readonly recordName?: string;
    /**
     * (experimental) The resource record cache time to live (TTL).
     *
     * @default Duration.minutes(30)
     * @experimental
     */
    readonly ttl?: Duration;
    /**
     * (experimental) A comment to add on the record.
     *
     * @default no comment
     * @experimental
     */
    readonly comment?: string;
}
/**
 * (experimental) Type union for a record that accepts multiple types of target.
 *
 * @experimental
 */
export declare class RecordTarget {
    readonly values?: string[] | undefined;
    readonly aliasTarget?: IAliasRecordTarget | undefined;
    /**
     * (experimental) Use string values as target.
     *
     * @experimental
     */
    static fromValues(...values: string[]): RecordTarget;
    /**
     * (experimental) Use an alias as target.
     *
     * @experimental
     */
    static fromAlias(aliasTarget: IAliasRecordTarget): RecordTarget;
    /**
     * (experimental) Use ip addresses as target.
     *
     * @experimental
     */
    static fromIpAddresses(...ipAddresses: string[]): RecordTarget;
    /**
     * @param values correspond with the chosen record type (e.g. for 'A' Type, specify one or more IP addresses).
     * @param aliasTarget alias for targets such as CloudFront distribution to route traffic to.
     * @experimental
     */
    protected constructor(values?: string[] | undefined, aliasTarget?: IAliasRecordTarget | undefined);
}
/**
 * (experimental) Construction properties for a RecordSet.
 *
 * @experimental
 */
export interface RecordSetProps extends RecordSetOptions {
    /**
     * (experimental) The record type.
     *
     * @experimental
     */
    readonly recordType: RecordType;
    /**
     * (experimental) The target for this record, either `RecordTarget.fromValues()` or `RecordTarget.fromAlias()`.
     *
     * @experimental
     */
    readonly target: RecordTarget;
}
/**
 * (experimental) A record set.
 *
 * @experimental
 */
export declare class RecordSet extends Resource implements IRecordSet {
    /**
     * (experimental) The domain name of the record.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RecordSetProps);
}
/**
 * (deprecated) Target for a DNS A Record.
 *
 * @deprecated Use RecordTarget
 */
export declare class AddressRecordTarget extends RecordTarget {
}
/**
 * (experimental) Construction properties for a ARecord.
 *
 * @experimental
 */
export interface ARecordProps extends RecordSetOptions {
    /**
     * (experimental) The target.
     *
     * @experimental
     */
    readonly target: RecordTarget;
}
/**
 * (experimental) A DNS A record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class ARecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ARecordProps);
}
/**
 * (experimental) Construction properties for a AaaaRecord.
 *
 * @experimental
 */
export interface AaaaRecordProps extends RecordSetOptions {
    /**
     * (experimental) The target.
     *
     * @experimental
     */
    readonly target: RecordTarget;
}
/**
 * (experimental) A DNS AAAA record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class AaaaRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AaaaRecordProps);
}
/**
 * (experimental) Construction properties for a CnameRecord.
 *
 * @experimental
 */
export interface CnameRecordProps extends RecordSetOptions {
    /**
     * (experimental) The domain name.
     *
     * @experimental
     */
    readonly domainName: string;
}
/**
 * (experimental) A DNS CNAME record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class CnameRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CnameRecordProps);
}
/**
 * (experimental) Construction properties for a TxtRecord.
 *
 * @experimental
 */
export interface TxtRecordProps extends RecordSetOptions {
    /**
     * (experimental) The text values.
     *
     * @experimental
     */
    readonly values: string[];
}
/**
 * (experimental) A DNS TXT record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class TxtRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TxtRecordProps);
}
/**
 * (experimental) Properties for a SRV record value.
 *
 * @experimental
 */
export interface SrvRecordValue {
    /**
     * (experimental) The priority.
     *
     * @experimental
     */
    readonly priority: number;
    /**
     * (experimental) The weight.
     *
     * @experimental
     */
    readonly weight: number;
    /**
     * (experimental) The port.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) The server host name.
     *
     * @experimental
     */
    readonly hostName: string;
}
/**
 * (experimental) Construction properties for a SrvRecord.
 *
 * @experimental
 */
export interface SrvRecordProps extends RecordSetOptions {
    /**
     * (experimental) The values.
     *
     * @experimental
     */
    readonly values: SrvRecordValue[];
}
/**
 * (experimental) A DNS SRV record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class SrvRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SrvRecordProps);
}
/**
 * (experimental) The CAA tag.
 *
 * @experimental
 */
export declare enum CaaTag {
    /**
     * (experimental) Explicity authorizes a single certificate authority to issue a certificate (any type) for the hostname.
     *
     * @experimental
     */
    ISSUE = "issue",
    /**
     * (experimental) Explicity authorizes a single certificate authority to issue a wildcard certificate (and only wildcard) for the hostname.
     *
     * @experimental
     */
    ISSUEWILD = "issuewild",
    /**
     * (experimental) Specifies a URL to which a certificate authority may report policy violations.
     *
     * @experimental
     */
    IODEF = "iodef"
}
/**
 * (experimental) Properties for a CAA record value.
 *
 * @experimental
 */
export interface CaaRecordValue {
    /**
     * (experimental) The flag.
     *
     * @experimental
     */
    readonly flag: number;
    /**
     * (experimental) The tag.
     *
     * @experimental
     */
    readonly tag: CaaTag;
    /**
     * (experimental) The value associated with the tag.
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) Construction properties for a CaaRecord.
 *
 * @experimental
 */
export interface CaaRecordProps extends RecordSetOptions {
    /**
     * (experimental) The values.
     *
     * @experimental
     */
    readonly values: CaaRecordValue[];
}
/**
 * (experimental) A DNS CAA record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class CaaRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CaaRecordProps);
}
/**
 * (experimental) Construction properties for a CaaAmazonRecord.
 *
 * @experimental
 */
export interface CaaAmazonRecordProps extends RecordSetOptions {
}
/**
 * (experimental) A DNS Amazon CAA record.
 *
 * A CAA record to restrict certificate authorities allowed
 * to issue certificates for a domain to Amazon only.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class CaaAmazonRecord extends CaaRecord {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CaaAmazonRecordProps);
}
/**
 * (experimental) Properties for a MX record value.
 *
 * @experimental
 */
export interface MxRecordValue {
    /**
     * (experimental) The priority.
     *
     * @experimental
     */
    readonly priority: number;
    /**
     * (experimental) The mail server host name.
     *
     * @experimental
     */
    readonly hostName: string;
}
/**
 * (experimental) Construction properties for a MxRecord.
 *
 * @experimental
 */
export interface MxRecordProps extends RecordSetOptions {
    /**
     * (experimental) The values.
     *
     * @experimental
     */
    readonly values: MxRecordValue[];
}
/**
 * (experimental) A DNS MX record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class MxRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: MxRecordProps);
}
/**
 * (experimental) Construction properties for a NSRecord.
 *
 * @experimental
 */
export interface NsRecordProps extends RecordSetOptions {
    /**
     * (experimental) The NS values.
     *
     * @experimental
     */
    readonly values: string[];
}
/**
 * (experimental) A DNS NS record.
 *
 * @experimental
 * @resource AWS::Route53::RecordSet
 */
export declare class NsRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NsRecordProps);
}
/**
 * (experimental) Construction properties for a ZoneDelegationRecord.
 *
 * @experimental
 */
export interface ZoneDelegationRecordProps extends RecordSetOptions {
    /**
     * (experimental) The name servers to report in the delegation records.
     *
     * @experimental
     */
    readonly nameServers: string[];
}
/**
 * (experimental) A record to delegate further lookups to a different set of name servers.
 *
 * @experimental
 */
export declare class ZoneDelegationRecord extends RecordSet {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ZoneDelegationRecordProps);
}
/**
 * (experimental) Construction properties for a CrossAccountZoneDelegationRecord.
 *
 * @experimental
 */
export interface CrossAccountZoneDelegationRecordProps {
    /**
     * (experimental) The zone to be delegated.
     *
     * @experimental
     */
    readonly delegatedZone: IHostedZone;
    /**
     * (experimental) The hosted zone name in the parent account.
     *
     * @default - no zone name
     * @experimental
     */
    readonly parentHostedZoneName?: string;
    /**
     * (experimental) The hosted zone id in the parent account.
     *
     * @default - no zone id
     * @experimental
     */
    readonly parentHostedZoneId?: string;
    /**
     * (experimental) The delegation role in the parent account.
     *
     * @experimental
     */
    readonly delegationRole: iam.IRole;
    /**
     * (experimental) The resource record cache time to live (TTL).
     *
     * @default Duration.days(2)
     * @experimental
     */
    readonly ttl?: Duration;
}
/**
 * (experimental) A Cross Account Zone Delegation record.
 *
 * @experimental
 */
export declare class CrossAccountZoneDelegationRecord extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CrossAccountZoneDelegationRecordProps);
}
