import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
import { HostedZoneProviderProps } from './hosted-zone-provider';
import { HostedZoneAttributes, IHostedZone } from './hosted-zone-ref';
import { CfnHostedZone } from './route53.generated';
/**
 * (experimental) Common properties to create a Route 53 hosted zone.
 *
 * @experimental
 */
export interface CommonHostedZoneProps {
    /**
     * (experimental) The name of the domain.
     *
     * For resource record types that include a domain
     * name, specify a fully qualified domain name.
     *
     * @experimental
     */
    readonly zoneName: string;
    /**
     * (experimental) Any comments that you want to include about the hosted zone.
     *
     * @default none
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
     *
     * @default disabled
     * @experimental
     */
    readonly queryLogsLogGroupArn?: string;
}
/**
 * (experimental) Properties of a new hosted zone.
 *
 * @experimental
 */
export interface HostedZoneProps extends CommonHostedZoneProps {
    /**
     * (experimental) A VPC that you want to associate with this hosted zone.
     *
     * When you specify
     * this property, a private hosted zone will be created.
     *
     * You can associate additional VPCs to this private zone using `addVpc(vpc)`.
     *
     * @default public (no VPCs associated)
     * @experimental
     */
    readonly vpcs?: ec2.IVpc[];
}
/**
 * (experimental) Container for records, and records contain information about how to route traffic for a specific domain, such as example.com and its subdomains (acme.example.com, zenith.example.com).
 *
 * @experimental
 */
export declare class HostedZone extends Resource implements IHostedZone {
    /**
     * (experimental) ARN of this hosted zone, such as arn:${Partition}:route53:::hostedzone/${Id}.
     *
     * @experimental
     */
    get hostedZoneArn(): string;
    /**
     * (experimental) Import a Route 53 hosted zone defined either outside the CDK, or in a different CDK stack.
     *
     * Use when hosted zone ID is known. Hosted zone name becomes unavailable through this query.
     *
     * @param scope the parent Construct for this Construct.
     * @param id the logical name of this Construct.
     * @param hostedZoneId the ID of the hosted zone to import.
     * @experimental
     */
    static fromHostedZoneId(scope: Construct, id: string, hostedZoneId: string): IHostedZone;
    /**
     * (experimental) Imports a hosted zone from another stack.
     *
     * Use when both hosted zone ID and hosted zone name are known.
     *
     * @param scope the parent Construct for this Construct.
     * @param id the logical name of this Construct.
     * @param attrs the HostedZoneAttributes (hosted zone ID and hosted zone name).
     * @experimental
     */
    static fromHostedZoneAttributes(scope: Construct, id: string, attrs: HostedZoneAttributes): IHostedZone;
    /**
     * (experimental) Lookup a hosted zone in the current account/region based on query parameters.
     *
     * Requires environment, you must specify env for the stack.
     *
     * Use to easily query hosted zones.
     *
     * @see https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     * @experimental
     */
    static fromLookup(scope: Construct, id: string, query: HostedZoneProviderProps): IHostedZone;
    /**
     * (experimental) ID of this hosted zone, such as "Z23ABC4XYZL05B".
     *
     * @experimental
     */
    readonly hostedZoneId: string;
    /**
     * (experimental) FQDN of this hosted zone.
     *
     * @experimental
     */
    readonly zoneName: string;
    /**
     * (experimental) Returns the set of name servers for the specific hosted zone. For example: ns1.example.com.
     *
     * This attribute will be undefined for private hosted zones or hosted zones imported from another stack.
     *
     * @experimental
     */
    readonly hostedZoneNameServers?: string[];
    /**
     * (experimental) VPCs to which this hosted zone will be added.
     *
     * @experimental
     */
    protected readonly vpcs: CfnHostedZone.VPCProperty[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HostedZoneProps);
    /**
     * (experimental) Add another VPC to this private hosted zone.
     *
     * @param vpc the other VPC to add.
     * @experimental
     */
    addVpc(vpc: ec2.IVpc): void;
}
/**
 * (experimental) Construction properties for a PublicHostedZone.
 *
 * @experimental
 */
export interface PublicHostedZoneProps extends CommonHostedZoneProps {
    /**
     * (experimental) Whether to create a CAA record to restrict certificate authorities allowed to issue certificates for this domain to Amazon only.
     *
     * @default false
     * @experimental
     */
    readonly caaAmazon?: boolean;
    /**
     * (experimental) A principal which is trusted to assume a role for zone delegation.
     *
     * @default - No delegation configuration
     * @experimental
     */
    readonly crossAccountZoneDelegationPrincipal?: iam.IPrincipal;
    /**
     * (experimental) The name of the role created for cross account delegation.
     *
     * @default - A role name is generated automatically
     * @experimental
     */
    readonly crossAccountZoneDelegationRoleName?: string;
}
/**
 * (experimental) Represents a Route 53 public hosted zone.
 *
 * @experimental
 */
export interface IPublicHostedZone extends IHostedZone {
}
/**
 * (experimental) Create a Route53 public hosted zone.
 *
 * @experimental
 * @resource AWS::Route53::HostedZone
 */
export declare class PublicHostedZone extends HostedZone implements IPublicHostedZone {
    /**
     * (experimental) Import a Route 53 public hosted zone defined either outside the CDK, or in a different CDK stack.
     *
     * @param scope the parent Construct for this Construct.
     * @param id the logical name of this Construct.
     * @param publicHostedZoneId the ID of the public hosted zone to import.
     * @experimental
     */
    static fromPublicHostedZoneId(scope: Construct, id: string, publicHostedZoneId: string): IPublicHostedZone;
    /**
     * (experimental) Role for cross account zone delegation.
     *
     * @experimental
     */
    readonly crossAccountZoneDelegationRole?: iam.Role;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PublicHostedZoneProps);
    /**
     * (experimental) Add another VPC to this private hosted zone.
     *
     * @experimental
     */
    addVpc(_vpc: ec2.IVpc): void;
    /**
     * (experimental) Adds a delegation from this zone to a designated zone.
     *
     * @param delegate the zone being delegated to.
     * @param opts options for creating the DNS record, if any.
     * @experimental
     */
    addDelegation(delegate: IPublicHostedZone, opts?: ZoneDelegationOptions): void;
}
/**
 * (experimental) Options available when creating a delegation relationship from one PublicHostedZone to another.
 *
 * @experimental
 */
export interface ZoneDelegationOptions {
    /**
     * (experimental) A comment to add on the DNS record created to incorporate the delegation.
     *
     * @default none
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The TTL (Time To Live) of the DNS delegation record in DNS caches.
     *
     * @default 172800
     * @experimental
     */
    readonly ttl?: Duration;
}
/**
 * (experimental) Properties to create a Route 53 private hosted zone.
 *
 * @experimental
 */
export interface PrivateHostedZoneProps extends CommonHostedZoneProps {
    /**
     * (experimental) A VPC that you want to associate with this hosted zone.
     *
     * Private hosted zones must be associated with at least one VPC. You can
     * associated additional VPCs using `addVpc(vpc)`.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
}
/**
 * (experimental) Represents a Route 53 private hosted zone.
 *
 * @experimental
 */
export interface IPrivateHostedZone extends IHostedZone {
}
/**
 * (experimental) Create a Route53 private hosted zone for use in one or more VPCs.
 *
 * Note that `enableDnsHostnames` and `enableDnsSupport` must have been enabled
 * for the VPC you're configuring for private hosted zones.
 *
 * @experimental
 * @resource AWS::Route53::HostedZone
 */
export declare class PrivateHostedZone extends HostedZone implements IPrivateHostedZone {
    /**
     * (experimental) Import a Route 53 private hosted zone defined either outside the CDK, or in a different CDK stack.
     *
     * @param scope the parent Construct for this Construct.
     * @param id the logical name of this Construct.
     * @param privateHostedZoneId the ID of the private hosted zone to import.
     * @experimental
     */
    static fromPrivateHostedZoneId(scope: Construct, id: string, privateHostedZoneId: string): IPrivateHostedZone;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PrivateHostedZoneProps);
}
