"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Set an InterfaceVpcEndpoint as a target for an ARecord.
 *
 * @experimental
 */
class InterfaceVpcEndpointTarget {
    /**
     * @experimental
     */
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpointTarget[_a] = { fqn: "monocdk.aws_route53_targets.InterfaceVpcEndpointTarget", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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