"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAcceleratorTarget = exports.GlobalAcceleratorDomainTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Use a Global Accelerator domain name as an alias record target.
 *
 * @experimental
 */
class GlobalAcceleratorDomainTarget {
    /**
     * (experimental) Create an Alias Target for a Global Accelerator domain name.
     *
     * @experimental
     */
    constructor(acceleratorDomainName) {
        this.acceleratorDomainName = acceleratorDomainName;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            hostedZoneId: GlobalAcceleratorTarget.GLOBAL_ACCELERATOR_ZONE_ID,
            dnsName: this.acceleratorDomainName,
        };
    }
}
exports.GlobalAcceleratorDomainTarget = GlobalAcceleratorDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorDomainTarget[_a] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorDomainTarget", version: "1.106.1" };
/**
 * (experimental) The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
 *
 * @experimental
 */
GlobalAcceleratorDomainTarget.GLOBAL_ACCELERATOR_ZONE_ID = 'Z2BJ6XQ5FK7U4H';
/**
 * (experimental) Use a Global Accelerator instance domain name as an alias record target.
 *
 * @experimental
 */
class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * (experimental) Create an Alias Target for a Global Accelerator instance.
     *
     * @experimental
     */
    constructor(accelerator) {
        super(accelerator.dnsName);
    }
}
exports.GlobalAcceleratorTarget = GlobalAcceleratorTarget;
_b = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorTarget[_b] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorTarget", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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